<?php

namespace RachidLaasri\LaravelInstaller\Helpers;

use Illuminate\Support\Facades\DB;
use App\Models\Addon;
use Illuminate\Support\Facades\File;

trait MigrationsHelper
{
    /**
     * Get the migrations in /database/migrations.
     *
     * @return array Array of migrations name, empty if no migrations are existing
     */
    public function getMigrations()
    {
        $migrations = collect(glob(database_path().DIRECTORY_SEPARATOR.'migrations'.DIRECTORY_SEPARATOR.'*.php'));

        try {
           $addons = Addon::get();
            foreach ($addons as $addon) {
                $packageMigration = ["packages/workdo/{$addon->package_name}/src/Database/Migrations", "packages/workdo/{$addon->package_name}/src/database/migrations"];
                foreach ($packageMigration as $dir) {
                    if (File::exists($dir)) {
                        $files = collect(File::glob("{$dir}/*.php"));
                        $migrations = $migrations->merge($files);
                    }
                }
            }
        } catch (\Exception $e) {
            // Do nothing
        }
        
        return $migrations->map(fn($path) => str_replace('.php', '', basename($path)));
    }

    /**
     * Get the migrations that have already been ran.
     *
     * @return \Illuminate\Support\Collection List of migrations
     */
    public function getExecutedMigrations()
    {
        // migrations table should exist, if not, user will receive an error.
        return DB::table('migrations')->get()->pluck('migration');
    }
}

