<?php

namespace RachidLaasri\LaravelInstaller\Controllers;

use Illuminate\Routing\Controller;
use RachidLaasri\LaravelInstaller\Events\LaravelInstallerFinished;
use RachidLaasri\LaravelInstaller\Helpers\EnvironmentManager;
use RachidLaasri\LaravelInstaller\Helpers\FinalInstallManager;
use RachidLaasri\LaravelInstaller\Helpers\InstalledFileManager;

class FinalController extends Controller
{
    /**
     * Update installed file and display finished view.
     *
     * @param \RachidLaasri\LaravelInstaller\Helpers\InstalledFileManager $fileManager
     * @param \RachidLaasri\LaravelInstaller\Helpers\FinalInstallManager $finalInstall
     * @param \RachidLaasri\LaravelInstaller\Helpers\EnvironmentManager $environment
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function finish(InstalledFileManager $fileManager, FinalInstallManager $finalInstall, EnvironmentManager $environment)
    {
        try {
            set_time_limit(300);
            
            $finalMessages = $finalInstall->runFinal();
            $finalStatusMessage = $fileManager->update();
            $finalEnvFile = $environment->getEnvContent();

            event(new LaravelInstallerFinished);

            return view('vendor.installer.finished', compact('finalMessages', 'finalStatusMessage', 'finalEnvFile'));
            
        } catch (\Exception $e) {
            \Log::error('Final installation step failed: ' . $e->getMessage());
            
            // Create installed file manually if it doesn't exist
            if (!file_exists(storage_path('installed'))) {
                file_put_contents(storage_path('installed'), 'Project successfully INSTALLED on ' . date('Y/m/d H:i:s'));
            }
            
            return view('vendor.installer.finished', [
                'finalMessages' => 'Installation completed with warnings.',
                'finalStatusMessage' => 'Application installed successfully.',
                'finalEnvFile' => ''
            ]);
        }
    }
}
