<?php

namespace RachidLaasri\LaravelInstaller\Controllers;

use Illuminate\Routing\Controller;
use RachidLaasri\LaravelInstaller\Helpers\DatabaseManager;

class DatabaseController extends Controller
{
    /**
     * @var DatabaseManager
     */
    private $databaseManager;

    /**
     * @param DatabaseManager $databaseManager
     */
    public function __construct(DatabaseManager $databaseManager)
    {
        $this->databaseManager = $databaseManager;
    }

    /**
     * Migrate and seed the database.
     *
     * @return \Illuminate\View\View
     */
    public function database()
    {
        // Show progress page instead of direct migration
        return view('vendor.installer.database');
    }

    /**
     * Run migration via AJAX
     */
    public function runMigration()
    {
        set_time_limit(600);
        
        $response = $this->databaseManager->migrateAndSeed();
        
        return response()->json($response);
    }
}
