<?php
/**
 * SettlementReconEntityDataInnerSettlementDetails
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Cashfree
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Cashfree Payment Gateway APIs
 *
 * Cashfree's Payment Gateway APIs provide developers with a streamlined pathway to integrate advanced payment processing capabilities into their applications, platforms and websites.
 *
 * The version of the OpenAPI document: 2025-01-01
 * Contact: developers@cashfree.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Cashfree\Model;

use \ArrayAccess;
use \Cashfree\ObjectSerializer;

/**
 * SettlementReconEntityDataInnerSettlementDetails Class Doc Comment
 *
 * @category Class
 * @package  Cashfree
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class SettlementReconEntityDataInnerSettlementDetails implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'SettlementReconEntity_data_inner_settlement_details';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'cf_settlement_id' => 'string',
        'settlement_date' => 'string',
        'utr' => 'string',
        'split_service_charge' => 'float',
        'split_service_tax' => 'float',
        'vendor_commission' => 'float',
        'payment_from' => 'string',
        'payment_till' => 'string',
        'reason' => 'string',
        'remarks' => 'string',
        'service_charge' => 'float',
        'service_tax' => 'float',
        'settlement_charge' => 'float',
        'settlement_initiated_on' => 'string',
        'settlement_tax' => 'float',
        'settlement_type' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'cf_settlement_id' => null,
        'settlement_date' => null,
        'utr' => null,
        'split_service_charge' => null,
        'split_service_tax' => null,
        'vendor_commission' => null,
        'payment_from' => null,
        'payment_till' => null,
        'reason' => null,
        'remarks' => null,
        'service_charge' => null,
        'service_tax' => null,
        'settlement_charge' => null,
        'settlement_initiated_on' => null,
        'settlement_tax' => null,
        'settlement_type' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static $openAPINullables = [
        'cf_settlement_id' => false,
		'settlement_date' => false,
		'utr' => false,
		'split_service_charge' => false,
		'split_service_tax' => false,
		'vendor_commission' => false,
		'payment_from' => false,
		'payment_till' => false,
		'reason' => false,
		'remarks' => false,
		'service_charge' => false,
		'service_tax' => false,
		'settlement_charge' => false,
		'settlement_initiated_on' => false,
		'settlement_tax' => false,
		'settlement_type' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'cf_settlement_id' => 'cf_settlement_id',
        'settlement_date' => 'settlement_date',
        'utr' => 'utr',
        'split_service_charge' => 'split_service_charge',
        'split_service_tax' => 'split_service_tax',
        'vendor_commission' => 'vendor_commission',
        'payment_from' => 'payment_from',
        'payment_till' => 'payment_till',
        'reason' => 'reason',
        'remarks' => 'remarks',
        'service_charge' => 'service_charge',
        'service_tax' => 'service_tax',
        'settlement_charge' => 'settlement_charge',
        'settlement_initiated_on' => 'settlement_initiated_on',
        'settlement_tax' => 'settlement_tax',
        'settlement_type' => 'settlement_type'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'cf_settlement_id' => 'setCfSettlementId',
        'settlement_date' => 'setSettlementDate',
        'utr' => 'setUtr',
        'split_service_charge' => 'setSplitServiceCharge',
        'split_service_tax' => 'setSplitServiceTax',
        'vendor_commission' => 'setVendorCommission',
        'payment_from' => 'setPaymentFrom',
        'payment_till' => 'setPaymentTill',
        'reason' => 'setReason',
        'remarks' => 'setRemarks',
        'service_charge' => 'setServiceCharge',
        'service_tax' => 'setServiceTax',
        'settlement_charge' => 'setSettlementCharge',
        'settlement_initiated_on' => 'setSettlementInitiatedOn',
        'settlement_tax' => 'setSettlementTax',
        'settlement_type' => 'setSettlementType'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'cf_settlement_id' => 'getCfSettlementId',
        'settlement_date' => 'getSettlementDate',
        'utr' => 'getUtr',
        'split_service_charge' => 'getSplitServiceCharge',
        'split_service_tax' => 'getSplitServiceTax',
        'vendor_commission' => 'getVendorCommission',
        'payment_from' => 'getPaymentFrom',
        'payment_till' => 'getPaymentTill',
        'reason' => 'getReason',
        'remarks' => 'getRemarks',
        'service_charge' => 'getServiceCharge',
        'service_tax' => 'getServiceTax',
        'settlement_charge' => 'getSettlementCharge',
        'settlement_initiated_on' => 'getSettlementInitiatedOn',
        'settlement_tax' => 'getSettlementTax',
        'settlement_type' => 'getSettlementType'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('cf_settlement_id', $data ?? [], null);
        $this->setIfExists('settlement_date', $data ?? [], null);
        $this->setIfExists('utr', $data ?? [], null);
        $this->setIfExists('split_service_charge', $data ?? [], null);
        $this->setIfExists('split_service_tax', $data ?? [], null);
        $this->setIfExists('vendor_commission', $data ?? [], null);
        $this->setIfExists('payment_from', $data ?? [], null);
        $this->setIfExists('payment_till', $data ?? [], null);
        $this->setIfExists('reason', $data ?? [], null);
        $this->setIfExists('remarks', $data ?? [], null);
        $this->setIfExists('service_charge', $data ?? [], null);
        $this->setIfExists('service_tax', $data ?? [], null);
        $this->setIfExists('settlement_charge', $data ?? [], null);
        $this->setIfExists('settlement_initiated_on', $data ?? [], null);
        $this->setIfExists('settlement_tax', $data ?? [], null);
        $this->setIfExists('settlement_type', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets cf_settlement_id
     *
     * @return string|null
     */
    public function getCfSettlementId()
    {
        return $this->container['cf_settlement_id'];
    }

    /**
     * Sets cf_settlement_id
     *
     * @param string|null $cf_settlement_id Unique ID to identify the settlement.
     *
     * @return self
     */
    public function setCfSettlementId($cf_settlement_id)
    {
        if (is_null($cf_settlement_id)) {
            throw new \InvalidArgumentException('non-nullable cf_settlement_id cannot be null');
        }
        $this->container['cf_settlement_id'] = $cf_settlement_id;

        return $this;
    }

    /**
     * Gets settlement_date
     *
     * @return string|null
     */
    public function getSettlementDate()
    {
        return $this->container['settlement_date'];
    }

    /**
     * Sets settlement_date
     *
     * @param string|null $settlement_date Date and time when the settlement was processed.
     *
     * @return self
     */
    public function setSettlementDate($settlement_date)
    {
        if (is_null($settlement_date)) {
            throw new \InvalidArgumentException('non-nullable settlement_date cannot be null');
        }
        $this->container['settlement_date'] = $settlement_date;

        return $this;
    }

    /**
     * Gets utr
     *
     * @return string|null
     */
    public function getUtr()
    {
        return $this->container['utr'];
    }

    /**
     * Sets utr
     *
     * @param string|null $utr Unique transaction reference number of the settlement.
     *
     * @return self
     */
    public function setUtr($utr)
    {
        if (is_null($utr)) {
            throw new \InvalidArgumentException('non-nullable utr cannot be null');
        }
        $this->container['utr'] = $utr;

        return $this;
    }

    /**
     * Gets split_service_charge
     *
     * @return float|null
     */
    public function getSplitServiceCharge()
    {
        return $this->container['split_service_charge'];
    }

    /**
     * Sets split_service_charge
     *
     * @param float|null $split_service_charge Service charge that is applicable for splitting the payment.
     *
     * @return self
     */
    public function setSplitServiceCharge($split_service_charge)
    {
        if (is_null($split_service_charge)) {
            throw new \InvalidArgumentException('non-nullable split_service_charge cannot be null');
        }
        $this->container['split_service_charge'] = $split_service_charge;

        return $this;
    }

    /**
     * Gets split_service_tax
     *
     * @return float|null
     */
    public function getSplitServiceTax()
    {
        return $this->container['split_service_tax'];
    }

    /**
     * Sets split_service_tax
     *
     * @param float|null $split_service_tax Service tax applicable for splitting the amount to vendors.
     *
     * @return self
     */
    public function setSplitServiceTax($split_service_tax)
    {
        if (is_null($split_service_tax)) {
            throw new \InvalidArgumentException('non-nullable split_service_tax cannot be null');
        }
        $this->container['split_service_tax'] = $split_service_tax;

        return $this;
    }

    /**
     * Gets vendor_commission
     *
     * @return float|null
     */
    public function getVendorCommission()
    {
        return $this->container['vendor_commission'];
    }

    /**
     * Sets vendor_commission
     *
     * @param float|null $vendor_commission Vendor commission applicable for this transaction.
     *
     * @return self
     */
    public function setVendorCommission($vendor_commission)
    {
        if (is_null($vendor_commission)) {
            throw new \InvalidArgumentException('non-nullable vendor_commission cannot be null');
        }
        $this->container['vendor_commission'] = $vendor_commission;

        return $this;
    }

    /**
     * Gets payment_from
     *
     * @return string|null
     */
    public function getPaymentFrom()
    {
        return $this->container['payment_from'];
    }

    /**
     * Sets payment_from
     *
     * @param string|null $payment_from Date and time from settlement computed.
     *
     * @return self
     */
    public function setPaymentFrom($payment_from)
    {
        if (is_null($payment_from)) {
            throw new \InvalidArgumentException('non-nullable payment_from cannot be null');
        }
        $this->container['payment_from'] = $payment_from;

        return $this;
    }

    /**
     * Gets payment_till
     *
     * @return string|null
     */
    public function getPaymentTill()
    {
        return $this->container['payment_till'];
    }

    /**
     * Sets payment_till
     *
     * @param string|null $payment_till Date and time till settlement computed.
     *
     * @return self
     */
    public function setPaymentTill($payment_till)
    {
        if (is_null($payment_till)) {
            throw new \InvalidArgumentException('non-nullable payment_till cannot be null');
        }
        $this->container['payment_till'] = $payment_till;

        return $this;
    }

    /**
     * Gets reason
     *
     * @return string|null
     */
    public function getReason()
    {
        return $this->container['reason'];
    }

    /**
     * Sets reason
     *
     * @param string|null $reason If any reason for settlement failure.
     *
     * @return self
     */
    public function setReason($reason)
    {
        if (is_null($reason)) {
            throw new \InvalidArgumentException('non-nullable reason cannot be null');
        }
        $this->container['reason'] = $reason;

        return $this;
    }

    /**
     * Gets remarks
     *
     * @return string|null
     */
    public function getRemarks()
    {
        return $this->container['remarks'];
    }

    /**
     * Sets remarks
     *
     * @param string|null $remarks Remarks related for settlement.
     *
     * @return self
     */
    public function setRemarks($remarks)
    {
        if (is_null($remarks)) {
            throw new \InvalidArgumentException('non-nullable remarks cannot be null');
        }
        $this->container['remarks'] = $remarks;

        return $this;
    }

    /**
     * Gets service_charge
     *
     * @return float|null
     */
    public function getServiceCharge()
    {
        return $this->container['service_charge'];
    }

    /**
     * Sets service_charge
     *
     * @param float|null $service_charge Service charge for the transactions.
     *
     * @return self
     */
    public function setServiceCharge($service_charge)
    {
        if (is_null($service_charge)) {
            throw new \InvalidArgumentException('non-nullable service_charge cannot be null');
        }
        $this->container['service_charge'] = $service_charge;

        return $this;
    }

    /**
     * Gets service_tax
     *
     * @return float|null
     */
    public function getServiceTax()
    {
        return $this->container['service_tax'];
    }

    /**
     * Sets service_tax
     *
     * @param float|null $service_tax Service tax for the transactions.
     *
     * @return self
     */
    public function setServiceTax($service_tax)
    {
        if (is_null($service_tax)) {
            throw new \InvalidArgumentException('non-nullable service_tax cannot be null');
        }
        $this->container['service_tax'] = $service_tax;

        return $this;
    }

    /**
     * Gets settlement_charge
     *
     * @return float|null
     */
    public function getSettlementCharge()
    {
        return $this->container['settlement_charge'];
    }

    /**
     * Sets settlement_charge
     *
     * @param float|null $settlement_charge Settlement Service Charge.
     *
     * @return self
     */
    public function setSettlementCharge($settlement_charge)
    {
        if (is_null($settlement_charge)) {
            throw new \InvalidArgumentException('non-nullable settlement_charge cannot be null');
        }
        $this->container['settlement_charge'] = $settlement_charge;

        return $this;
    }

    /**
     * Gets settlement_initiated_on
     *
     * @return string|null
     */
    public function getSettlementInitiatedOn()
    {
        return $this->container['settlement_initiated_on'];
    }

    /**
     * Sets settlement_initiated_on
     *
     * @param string|null $settlement_initiated_on Date and time when Settlement initiated.
     *
     * @return self
     */
    public function setSettlementInitiatedOn($settlement_initiated_on)
    {
        if (is_null($settlement_initiated_on)) {
            throw new \InvalidArgumentException('non-nullable settlement_initiated_on cannot be null');
        }
        $this->container['settlement_initiated_on'] = $settlement_initiated_on;

        return $this;
    }

    /**
     * Gets settlement_tax
     *
     * @return float|null
     */
    public function getSettlementTax()
    {
        return $this->container['settlement_tax'];
    }

    /**
     * Sets settlement_tax
     *
     * @param float|null $settlement_tax Settlement Service Tax.
     *
     * @return self
     */
    public function setSettlementTax($settlement_tax)
    {
        if (is_null($settlement_tax)) {
            throw new \InvalidArgumentException('non-nullable settlement_tax cannot be null');
        }
        $this->container['settlement_tax'] = $settlement_tax;

        return $this;
    }

    /**
     * Gets settlement_type
     *
     * @return string|null
     */
    public function getSettlementType()
    {
        return $this->container['settlement_type'];
    }

    /**
     * Sets settlement_type
     *
     * @param string|null $settlement_type Type of Settlement, Example - Normal Settlement.
     *
     * @return self
     */
    public function setSettlementType($settlement_type)
    {
        if (is_null($settlement_type)) {
            throw new \InvalidArgumentException('non-nullable settlement_type cannot be null');
        }
        $this->container['settlement_type'] = $settlement_type;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


