<?php
/**
 * SettlementReconEntityDataInnerEventDetails
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Cashfree
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Cashfree Payment Gateway APIs
 *
 * Cashfree's Payment Gateway APIs provide developers with a streamlined pathway to integrate advanced payment processing capabilities into their applications, platforms and websites.
 *
 * The version of the OpenAPI document: 2025-01-01
 * Contact: developers@cashfree.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Cashfree\Model;

use \ArrayAccess;
use \Cashfree\ObjectSerializer;

/**
 * SettlementReconEntityDataInnerEventDetails Class Doc Comment
 *
 * @category Class
 * @package  Cashfree
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class SettlementReconEntityDataInnerEventDetails implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'SettlementReconEntity_data_inner_event_details';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'event_id' => 'string',
        'event_type' => 'string',
        'event_settlement_amount' => 'float',
        'event_amount' => 'float',
        'sale_type' => 'string',
        'event_status' => 'string',
        'entity' => 'string',
        'event_time' => 'string',
        'event_currency' => 'string',
        'event_service_charge' => 'float',
        'event_service_tax' => 'float',
        'event_remarks' => 'float'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'event_id' => null,
        'event_type' => null,
        'event_settlement_amount' => null,
        'event_amount' => null,
        'sale_type' => null,
        'event_status' => null,
        'entity' => null,
        'event_time' => null,
        'event_currency' => null,
        'event_service_charge' => null,
        'event_service_tax' => null,
        'event_remarks' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static $openAPINullables = [
        'event_id' => false,
		'event_type' => false,
		'event_settlement_amount' => false,
		'event_amount' => false,
		'sale_type' => false,
		'event_status' => false,
		'entity' => false,
		'event_time' => false,
		'event_currency' => false,
		'event_service_charge' => false,
		'event_service_tax' => false,
		'event_remarks' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'event_id' => 'event_id',
        'event_type' => 'event_type',
        'event_settlement_amount' => 'event_settlement_amount',
        'event_amount' => 'event_amount',
        'sale_type' => 'sale_type',
        'event_status' => 'event_status',
        'entity' => 'entity',
        'event_time' => 'event_time',
        'event_currency' => 'event_currency',
        'event_service_charge' => 'event_service_charge',
        'event_service_tax' => 'event_service_tax',
        'event_remarks' => 'event_remarks'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'event_id' => 'setEventId',
        'event_type' => 'setEventType',
        'event_settlement_amount' => 'setEventSettlementAmount',
        'event_amount' => 'setEventAmount',
        'sale_type' => 'setSaleType',
        'event_status' => 'setEventStatus',
        'entity' => 'setEntity',
        'event_time' => 'setEventTime',
        'event_currency' => 'setEventCurrency',
        'event_service_charge' => 'setEventServiceCharge',
        'event_service_tax' => 'setEventServiceTax',
        'event_remarks' => 'setEventRemarks'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'event_id' => 'getEventId',
        'event_type' => 'getEventType',
        'event_settlement_amount' => 'getEventSettlementAmount',
        'event_amount' => 'getEventAmount',
        'sale_type' => 'getSaleType',
        'event_status' => 'getEventStatus',
        'entity' => 'getEntity',
        'event_time' => 'getEventTime',
        'event_currency' => 'getEventCurrency',
        'event_service_charge' => 'getEventServiceCharge',
        'event_service_tax' => 'getEventServiceTax',
        'event_remarks' => 'getEventRemarks'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('event_id', $data ?? [], null);
        $this->setIfExists('event_type', $data ?? [], null);
        $this->setIfExists('event_settlement_amount', $data ?? [], null);
        $this->setIfExists('event_amount', $data ?? [], null);
        $this->setIfExists('sale_type', $data ?? [], null);
        $this->setIfExists('event_status', $data ?? [], null);
        $this->setIfExists('entity', $data ?? [], null);
        $this->setIfExists('event_time', $data ?? [], null);
        $this->setIfExists('event_currency', $data ?? [], null);
        $this->setIfExists('event_service_charge', $data ?? [], null);
        $this->setIfExists('event_service_tax', $data ?? [], null);
        $this->setIfExists('event_remarks', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets event_id
     *
     * @return string|null
     */
    public function getEventId()
    {
        return $this->container['event_id'];
    }

    /**
     * Sets event_id
     *
     * @param string|null $event_id Unique ID associated with the event.
     *
     * @return self
     */
    public function setEventId($event_id)
    {
        if (is_null($event_id)) {
            throw new \InvalidArgumentException('non-nullable event_id cannot be null');
        }
        $this->container['event_id'] = $event_id;

        return $this;
    }

    /**
     * Gets event_type
     *
     * @return string|null
     */
    public function getEventType()
    {
        return $this->container['event_type'];
    }

    /**
     * Sets event_type
     *
     * @param string|null $event_type The event type can be PAYMENT, REFUND, REFUND_REVERSAL, DISPUTE, DISPUTE_REVERSAL, CHARGEBACK, CHARGEBACK_REVERSAL, OTHER_ADJUSTMENT.
     *
     * @return self
     */
    public function setEventType($event_type)
    {
        if (is_null($event_type)) {
            throw new \InvalidArgumentException('non-nullable event_type cannot be null');
        }
        $this->container['event_type'] = $event_type;

        return $this;
    }

    /**
     * Gets event_settlement_amount
     *
     * @return float|null
     */
    public function getEventSettlementAmount()
    {
        return $this->container['event_settlement_amount'];
    }

    /**
     * Sets event_settlement_amount
     *
     * @param float|null $event_settlement_amount Amount that is part of the settlement corresponding to the event.
     *
     * @return self
     */
    public function setEventSettlementAmount($event_settlement_amount)
    {
        if (is_null($event_settlement_amount)) {
            throw new \InvalidArgumentException('non-nullable event_settlement_amount cannot be null');
        }
        $this->container['event_settlement_amount'] = $event_settlement_amount;

        return $this;
    }

    /**
     * Gets event_amount
     *
     * @return float|null
     */
    public function getEventAmount()
    {
        return $this->container['event_amount'];
    }

    /**
     * Sets event_amount
     *
     * @param float|null $event_amount Amount corresponding to the event. Example, refund amount, dispute amount, payment amount, etc.
     *
     * @return self
     */
    public function setEventAmount($event_amount)
    {
        if (is_null($event_amount)) {
            throw new \InvalidArgumentException('non-nullable event_amount cannot be null');
        }
        $this->container['event_amount'] = $event_amount;

        return $this;
    }

    /**
     * Gets sale_type
     *
     * @return string|null
     */
    public function getSaleType()
    {
        return $this->container['sale_type'];
    }

    /**
     * Sets sale_type
     *
     * @param string|null $sale_type Indicates if it is CREDIT/DEBIT sale.
     *
     * @return self
     */
    public function setSaleType($sale_type)
    {
        if (is_null($sale_type)) {
            throw new \InvalidArgumentException('non-nullable sale_type cannot be null');
        }
        $this->container['sale_type'] = $sale_type;

        return $this;
    }

    /**
     * Gets event_status
     *
     * @return string|null
     */
    public function getEventStatus()
    {
        return $this->container['event_status'];
    }

    /**
     * Sets event_status
     *
     * @param string|null $event_status Status of the event. Example - SUCCESS, FAILED, PENDING, CANCELLED.
     *
     * @return self
     */
    public function setEventStatus($event_status)
    {
        if (is_null($event_status)) {
            throw new \InvalidArgumentException('non-nullable event_status cannot be null');
        }
        $this->container['event_status'] = $event_status;

        return $this;
    }

    /**
     * Gets entity
     *
     * @return string|null
     */
    public function getEntity()
    {
        return $this->container['entity'];
    }

    /**
     * Sets entity
     *
     * @param string|null $entity Recon
     *
     * @return self
     */
    public function setEntity($entity)
    {
        if (is_null($entity)) {
            throw new \InvalidArgumentException('non-nullable entity cannot be null');
        }
        $this->container['entity'] = $entity;

        return $this;
    }

    /**
     * Gets event_time
     *
     * @return string|null
     */
    public function getEventTime()
    {
        return $this->container['event_time'];
    }

    /**
     * Sets event_time
     *
     * @param string|null $event_time Time associated with the event. Example, transaction time, dispute initiation time
     *
     * @return self
     */
    public function setEventTime($event_time)
    {
        if (is_null($event_time)) {
            throw new \InvalidArgumentException('non-nullable event_time cannot be null');
        }
        $this->container['event_time'] = $event_time;

        return $this;
    }

    /**
     * Gets event_currency
     *
     * @return string|null
     */
    public function getEventCurrency()
    {
        return $this->container['event_currency'];
    }

    /**
     * Sets event_currency
     *
     * @param string|null $event_currency Curreny type - INR.
     *
     * @return self
     */
    public function setEventCurrency($event_currency)
    {
        if (is_null($event_currency)) {
            throw new \InvalidArgumentException('non-nullable event_currency cannot be null');
        }
        $this->container['event_currency'] = $event_currency;

        return $this;
    }

    /**
     * Gets event_service_charge
     *
     * @return float|null
     */
    public function getEventServiceCharge()
    {
        return $this->container['event_service_charge'];
    }

    /**
     * Sets event_service_charge
     *
     * @param float|null $event_service_charge Service charge for above event_type.
     *
     * @return self
     */
    public function setEventServiceCharge($event_service_charge)
    {
        if (is_null($event_service_charge)) {
            throw new \InvalidArgumentException('non-nullable event_service_charge cannot be null');
        }
        $this->container['event_service_charge'] = $event_service_charge;

        return $this;
    }

    /**
     * Gets event_service_tax
     *
     * @return float|null
     */
    public function getEventServiceTax()
    {
        return $this->container['event_service_tax'];
    }

    /**
     * Sets event_service_tax
     *
     * @param float|null $event_service_tax Service tax for above event_type.
     *
     * @return self
     */
    public function setEventServiceTax($event_service_tax)
    {
        if (is_null($event_service_tax)) {
            throw new \InvalidArgumentException('non-nullable event_service_tax cannot be null');
        }
        $this->container['event_service_tax'] = $event_service_tax;

        return $this;
    }

    /**
     * Gets event_remarks
     *
     * @return float|null
     */
    public function getEventRemarks()
    {
        return $this->container['event_remarks'];
    }

    /**
     * Sets event_remarks
     *
     * @param float|null $event_remarks Remarks for above event_type.
     *
     * @return self
     */
    public function setEventRemarks($event_remarks)
    {
        if (is_null($event_remarks)) {
            throw new \InvalidArgumentException('non-nullable event_remarks cannot be null');
        }
        $this->container['event_remarks'] = $event_remarks;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


