<?php
/**
 * CartDetails
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Cashfree
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Cashfree Payment Gateway APIs
 *
 * Cashfree's Payment Gateway APIs provide developers with a streamlined pathway to integrate advanced payment processing capabilities into their applications, platforms and websites.
 *
 * The version of the OpenAPI document: 2025-01-01
 * Contact: developers@cashfree.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Cashfree\Model;

use \ArrayAccess;
use \Cashfree\ObjectSerializer;

/**
 * CartDetails Class Doc Comment
 *
 * @category Class
 * @description The cart details that are necessary like shipping address, billing address and more.
 * @package  Cashfree
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class CartDetails implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'CartDetails';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'customer_note' => 'string',
        'shipping_charge' => 'float',
        'cart_name' => 'string',
        'customer_shipping_address' => '\Cashfree\Model\CartAddress',
        'customer_billing_address' => '\Cashfree\Model\CartAddress',
        'cart_items' => '\Cashfree\Model\CartItem[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'customer_note' => null,
        'shipping_charge' => 'double',
        'cart_name' => null,
        'customer_shipping_address' => null,
        'customer_billing_address' => null,
        'cart_items' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static $openAPINullables = [
        'customer_note' => false,
		'shipping_charge' => false,
		'cart_name' => false,
		'customer_shipping_address' => false,
		'customer_billing_address' => false,
		'cart_items' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'customer_note' => 'customer_note',
        'shipping_charge' => 'shipping_charge',
        'cart_name' => 'cart_name',
        'customer_shipping_address' => 'customer_shipping_address',
        'customer_billing_address' => 'customer_billing_address',
        'cart_items' => 'cart_items'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'customer_note' => 'setCustomerNote',
        'shipping_charge' => 'setShippingCharge',
        'cart_name' => 'setCartName',
        'customer_shipping_address' => 'setCustomerShippingAddress',
        'customer_billing_address' => 'setCustomerBillingAddress',
        'cart_items' => 'setCartItems'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'customer_note' => 'getCustomerNote',
        'shipping_charge' => 'getShippingCharge',
        'cart_name' => 'getCartName',
        'customer_shipping_address' => 'getCustomerShippingAddress',
        'customer_billing_address' => 'getCustomerBillingAddress',
        'cart_items' => 'getCartItems'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('customer_note', $data ?? [], null);
        $this->setIfExists('shipping_charge', $data ?? [], null);
        $this->setIfExists('cart_name', $data ?? [], null);
        $this->setIfExists('customer_shipping_address', $data ?? [], null);
        $this->setIfExists('customer_billing_address', $data ?? [], null);
        $this->setIfExists('cart_items', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets customer_note
     *
     * @return string|null
     */
    public function getCustomerNote()
    {
        return $this->container['customer_note'];
    }

    /**
     * Sets customer_note
     *
     * @param string|null $customer_note customer_note
     *
     * @return self
     */
    public function setCustomerNote($customer_note)
    {
        if (is_null($customer_note)) {
            throw new \InvalidArgumentException('non-nullable customer_note cannot be null');
        }
        $this->container['customer_note'] = $customer_note;

        return $this;
    }

    /**
     * Gets shipping_charge
     *
     * @return float|null
     */
    public function getShippingCharge()
    {
        return $this->container['shipping_charge'];
    }

    /**
     * Sets shipping_charge
     *
     * @param float|null $shipping_charge shipping_charge
     *
     * @return self
     */
    public function setShippingCharge($shipping_charge)
    {
        if (is_null($shipping_charge)) {
            throw new \InvalidArgumentException('non-nullable shipping_charge cannot be null');
        }
        $this->container['shipping_charge'] = $shipping_charge;

        return $this;
    }

    /**
     * Gets cart_name
     *
     * @return string|null
     */
    public function getCartName()
    {
        return $this->container['cart_name'];
    }

    /**
     * Sets cart_name
     *
     * @param string|null $cart_name Name of the cart.
     *
     * @return self
     */
    public function setCartName($cart_name)
    {
        if (is_null($cart_name)) {
            throw new \InvalidArgumentException('non-nullable cart_name cannot be null');
        }
        $this->container['cart_name'] = $cart_name;

        return $this;
    }

    /**
     * Gets customer_shipping_address
     *
     * @return \Cashfree\Model\CartAddress|null
     */
    public function getCustomerShippingAddress()
    {
        return $this->container['customer_shipping_address'];
    }

    /**
     * Sets customer_shipping_address
     *
     * @param \Cashfree\Model\CartAddress|null $customer_shipping_address customer_shipping_address
     *
     * @return self
     */
    public function setCustomerShippingAddress($customer_shipping_address)
    {
        if (is_null($customer_shipping_address)) {
            throw new \InvalidArgumentException('non-nullable customer_shipping_address cannot be null');
        }
        $this->container['customer_shipping_address'] = $customer_shipping_address;

        return $this;
    }

    /**
     * Gets customer_billing_address
     *
     * @return \Cashfree\Model\CartAddress|null
     */
    public function getCustomerBillingAddress()
    {
        return $this->container['customer_billing_address'];
    }

    /**
     * Sets customer_billing_address
     *
     * @param \Cashfree\Model\CartAddress|null $customer_billing_address customer_billing_address
     *
     * @return self
     */
    public function setCustomerBillingAddress($customer_billing_address)
    {
        if (is_null($customer_billing_address)) {
            throw new \InvalidArgumentException('non-nullable customer_billing_address cannot be null');
        }
        $this->container['customer_billing_address'] = $customer_billing_address;

        return $this;
    }

    /**
     * Gets cart_items
     *
     * @return \Cashfree\Model\CartItem[]|null
     */
    public function getCartItems()
    {
        return $this->container['cart_items'];
    }

    /**
     * Sets cart_items
     *
     * @param \Cashfree\Model\CartItem[]|null $cart_items cart_items
     *
     * @return self
     */
    public function setCartItems($cart_items)
    {
        if (is_null($cart_items)) {
            throw new \InvalidArgumentException('non-nullable cart_items cannot be null');
        }
        $this->container['cart_items'] = $cart_items;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


