<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Dashboard Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            color: #333;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #e5e7eb;
            padding-bottom: 20px;
        }
        .header h1 {
            color: #1f2937;
            margin: 0;
            font-size: 28px;
        }
        .header p {
            color: #6b7280;
            margin: 5px 0 0 0;
        }
        .stats-grid {
            display: table;
            width: 100%;
            margin-bottom: 30px;
        }
        .stat-card {
            display: table-cell;
            width: 25%;
            vertical-align: top;
            margin-right: 20px;
        }
        .stat-card {
            background: #f9fafb;
            border: 1px solid #e5e7eb;
            border-radius: 8px;
            padding: 20px;
            text-align: center;
        }
        .stat-value {
            font-size: 24px;
            font-weight: bold;
            color: #1f2937;
            margin-bottom: 5px;
        }
        .stat-label {
            color: #6b7280;
            font-size: 14px;
        }
        .section {
            margin-bottom: 30px;
        }
        .section-title {
            font-size: 18px;
            font-weight: bold;
            color: #1f2937;
            margin-bottom: 15px;
            border-bottom: 1px solid #e5e7eb;
            padding-bottom: 5px;
        }
        .activity-item {
            background: #f9fafb;
            border-left: 4px solid #10b77f;
            padding: 10px 15px;
            margin-bottom: 10px;
            border-radius: 0 4px 4px 0;
        }
        .activity-message {
            font-weight: 500;
            margin-bottom: 3px;
        }
        .activity-time {
            font-size: 12px;
            color: #6b7280;
        }
        .plans-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }
        .plans-table th,
        .plans-table td {
            border: 1px solid #e5e7eb;
            padding: 10px;
            text-align: left;
        }
        .plans-table th {
            background: #f3f4f6;
            font-weight: bold;
        }
        .footer {
            margin-top: 40px;
            text-align: center;
            color: #6b7280;
            font-size: 12px;
            border-top: 1px solid #e5e7eb;
            padding-top: 20px;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Dashboard Report</h1>
        <p>Generated on {{ $data['generatedAt'] }}</p>
        <p>Report Type: {{ ucfirst($data['userType']) }} Dashboard</p>
    </div>

    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-value">{{ number_format($data['totalCompanies']) }}</div>
            <div class="stat-label">Total Companies</div>
        </div>
        <div class="stat-card">
            <div class="stat-value">{{ number_format($data['totalUsers']) }}</div>
            <div class="stat-label">Total Users</div>
        </div>
        <div class="stat-card">
            <div class="stat-value">{{ number_format($data['activePlans']) }}</div>
            <div class="stat-label">Active Plans</div>
        </div>
        <div class="stat-card">
            <div class="stat-value">{{ number_format($data['totalNfcCards']) }}</div>
            <div class="stat-label">NFC Cards</div>
        </div>
    </div>

    <div class="footer">
        <p>This report was automatically generated by vCard SaaS</p>
        <p>© {{ date('Y') }} vCard SaaS. All rights reserved.</p>
    </div>
</body>
</html>