import { socialPlatformsConfig } from '../social-platforms-config';
import languageData from '@/../../resources/lang/language.json';

export const neutralProfessionalTemplate = {
  name: 'Neutral Professional',
  sections: [
    {
      key: 'header',
      name: 'Header',
      fields: [
        { name: 'name', type: 'text', label: 'Full Name' },
        { name: 'title', type: 'text', label: 'Professional Title' },
        { name: 'tagline', type: 'textarea', label: 'Tagline' },
        { name: 'profile_image', type: 'file', label: 'Profile Image' }
      ],
      required: true
    },
    {
      key: 'contact',
      name: 'Contact Information',
      fields: [
        { name: 'email', type: 'email', label: 'Email Address' },
        { name: 'phone', type: 'tel', label: 'Phone Number' },
        { name: 'website', type: 'url', label: 'Website URL' },
        { name: 'location', type: 'text', label: 'Location' }
      ],
      required: true
    },
    {
      key: 'about',
      name: 'About',
      fields: [
        { name: 'description', type: 'textarea', label: 'About Me' },
        { name: 'skills', type: 'tags', label: 'Skills & Expertise' },
        { name: 'experience', type: 'number', label: 'Years of Experience' }
      ],
      required: false
    },
    {
      key: 'services',
      name: 'Services',
      fields: [
        {
          name: 'service_list',
          type: 'repeater',
          label: 'Services Offered',
          fields: [
            { name: 'title', type: 'text', label: 'Service Title' },
            { name: 'description', type: 'textarea', label: 'Description' },
            { name: 'price', type: 'text', label: 'Price/Rate' }
          ]
        }
      ],
      required: false
    },
    {
      key: 'portfolio',
      name: 'Portfolio/Work',
      fields: [
        {
          name: 'projects',
          type: 'repeater',
          label: 'Work Samples',
          fields: [
            { name: 'title', type: 'text', label: 'Project Title' },
            { name: 'description', type: 'textarea', label: 'Description' },
            { name: 'image', type: 'file', label: 'Image' },
            { name: 'url', type: 'url', label: 'Project URL' }
          ]
        }
      ],
      required: false
    },
    {
      key: 'social',
      name: 'Social Media',
      fields: [
        {
          name: 'social_links',
          type: 'repeater',
          label: 'Social Media Links',
          fields: [
            { name: 'platform', type: 'select', label: 'Platform', options: socialPlatformsConfig.map(p => ({ value: p.value, label: p.label })) },
            { name: 'url', type: 'url', label: 'Profile URL' },
            { name: 'username', type: 'text', label: 'Username' }
          ]
        }
      ],
      required: false
    },
    {
      key: 'business_hours',
      name: 'Business Hours',
      fields: [
        {
          name: 'hours',
          type: 'repeater',
          label: 'Business Hours',
          fields: [
            { name: 'day', type: 'select', label: 'Day', options: [
              { value: 'monday', label: 'Monday' },
              { value: 'tuesday', label: 'Tuesday' },
              { value: 'wednesday', label: 'Wednesday' },
              { value: 'thursday', label: 'Thursday' },
              { value: 'friday', label: 'Friday' },
              { value: 'saturday', label: 'Saturday' },
              { value: 'sunday', label: 'Sunday' }
            ]},
            { name: 'open_time', type: 'time', label: 'Opening Time' },
            { name: 'close_time', type: 'time', label: 'Closing Time' },
            { name: 'is_closed', type: 'checkbox', label: 'Closed' }
          ]
        }
      ],
      required: false
    },
    {
      key: 'testimonials',
      name: 'Testimonials',
      fields: [
        {
          name: 'reviews',
          type: 'repeater',
          label: 'Client Reviews',
          fields: [
            { name: 'client_name', type: 'text', label: 'Client Name' },
            { name: 'review', type: 'textarea', label: 'Review Text' },
            { name: 'rating', type: 'number', label: 'Rating (1-5)' }
          ]
        }
      ],
      required: false
    },
    {
      key: 'appointments',
      name: 'Appointments',
      fields: [
        { name: 'booking_url', type: 'url', label: 'Booking URL' },
        { name: 'calendar_link', type: 'url', label: 'Calendar Link' }
      ],
      required: false
    },
    {
      key: 'google_map',
      name: 'Location',
      fields: [
        { name: 'map_embed_url', type: 'textarea', label: 'Google Maps Embed URL' },
        { name: 'directions_url', type: 'url', label: 'Google Maps Directions URL' }
      ],
      required: false
    },
    {
      key: 'app_download',
      name: 'App Download',
      fields: [
        { name: 'app_store_url', type: 'url', label: 'App Store URL' },
        { name: 'play_store_url', type: 'url', label: 'Play Store URL' }
      ],
      required: false
    },
    {
      key: 'custom_html',
      name: 'Custom HTML',
      fields: [
        { name: 'html_content', type: 'textarea', label: 'Custom HTML Code' },
        { name: 'section_title', type: 'text', label: 'Section Title' },
        { name: 'show_title', type: 'checkbox', label: 'Show Section Title' }
      ],
      required: false
    },
    {
      key: 'qr_share',
      name: 'QR Code Share',
      fields: [
        { name: 'enable_qr', type: 'checkbox', label: 'Enable QR Code Sharing' },
        { name: 'qr_title', type: 'text', label: 'QR Section Title' },
        { name: 'qr_description', type: 'textarea', label: 'QR Description' }
      ],
      required: false
    },
    {
      key: 'thank_you',
      name: 'Thank You Message',
      fields: [
        { name: 'message', type: 'textarea', label: 'Thank You Message' }
      ],
      required: false
    },
    {
      key: 'action_buttons',
      name: 'Action Buttons',
      fields: [
        { name: 'contact_button_text', type: 'text', label: 'Contact Button Text' },
        { name: 'save_contact_button_text', type: 'text', label: 'Save Contact Button Text' }
      ],
      required: false
    },
    {
      key: 'copyright',
      name: 'Copyright',
      fields: [
        { name: 'text', type: 'text', label: 'Copyright Text' }
      ],
      required: false
    },
    {
      key: 'contact_form',
      name: 'Contact Form',
      fields: [
        { name: 'form_title', type: 'text', label: 'Form Title' },
        { name: 'form_description', type: 'textarea', label: 'Form Description' }
      ],
      required: false
    },
    {
      key: 'language',
      name: 'Language Settings',
      fields: [
        { name: 'template_language', type: 'select', label: 'Template Language', options: languageData.map(lang => ({ value: lang.code, label: `${String.fromCodePoint(...lang.countryCode.toUpperCase().split('').map(char => 127397 + char.charCodeAt()))} ${lang.name}` })) }
      ],
      required: false
    }
  ],
  colorPresets: [
    { name: 'Clean White', primary: '#2563EB', secondary: '#3B82F6', accent: '#F1F5F9', background: '#FFFFFF', text: '#1E293B', cardBg: '#FFFFFF', borderColor: '#E2E8F0' },
    { name: 'Minimal Gray', primary: '#374151', secondary: '#6B7280', accent: '#F9FAFB', background: '#F8FAFC', text: '#111827', cardBg: '#FFFFFF', borderColor: '#D1D5DB' },
    { name: 'Professional Black', primary: '#000000', secondary: '#374151', accent: '#F3F4F6', background: '#FFFFFF', text: '#000000', cardBg: '#FAFAFA', borderColor: '#E5E7EB' },
    { name: 'Warm Beige', primary: '#92400E', secondary: '#B45309', accent: '#FEF3C7', background: '#FFFBEB', text: '#451A03', cardBg: '#FFFFFF', borderColor: '#F3E8FF' },
    { name: 'Modern Teal', primary: '#0F766E', secondary: '#14B8A6', accent: '#F0FDFA', background: '#FFFFFF', text: '#134E4A', cardBg: '#FFFFFF', borderColor: '#99F6E4' }
  ],
  fontOptions: [
    { name: 'Inter', value: 'Inter, -apple-system, BlinkMacSystemFont, sans-serif', weight: '400,500,600,700' },
    { name: 'Roboto', value: 'Roboto, -apple-system, BlinkMacSystemFont, sans-serif', weight: '400,500,700' },
    { name: 'Open Sans', value: 'Open Sans, -apple-system, BlinkMacSystemFont, sans-serif', weight: '400,600,700' },
    { name: 'Lato', value: 'Lato, -apple-system, BlinkMacSystemFont, sans-serif', weight: '400,700' }
  ],
  defaultColors: {
    primary: '#2563EB',
    secondary: '#3B82F6',
    accent: '#F1F5F9',
    background: '#FFFFFF',
    text: '#1E293B',
    cardBg: '#FFFFFF',
    borderColor: '#E2E8F0'
  },
  defaultFont: 'Inter, -apple-system, BlinkMacSystemFont, sans-serif',
  themeStyle: {
    layout: 'clean-minimal',
    headerStyle: 'simple',
    cardStyle: 'clean',
    buttonStyle: 'minimal',
    iconStyle: 'simple',
    spacing: 'comfortable',
    shadows: 'subtle',
    animations: 'smooth'
  },
  defaultData: {
    header: {
      name: 'Your Name',
      title: 'Professional Title',
      tagline: 'Your professional tagline or mission statement',
      profile_image: ''
    },
    contact: {
      email: 'your.email@example.com',
      phone: '+1 (555) 123-4567',
      website: 'https://yourwebsite.com',
      location: 'Your City, State'
    },
    about: {
      description: 'Brief description about yourself and your professional background.',
      skills: 'Skill 1, Skill 2, Skill 3',
      experience: '5'
    },
    services: {
      service_list: [
        { title: 'Service 1', description: 'Description of your first service', price: 'Contact for pricing' },
        { title: 'Service 2', description: 'Description of your second service', price: 'Contact for pricing' }
      ]
    },
    portfolio: {
      projects: [
        { title: 'Project Alpha', description: 'Comprehensive business solution with modern design approach', image: '', url: '#' },
        { title: 'Digital Strategy', description: 'Complete digital transformation for enterprise client', image: '', url: '#' },
        { title: 'Brand Identity', description: 'Full brand redesign and marketing strategy implementation', image: '', url: '#' },
        { title: 'Web Platform', description: 'Custom web application with advanced functionality', image: '', url: '#' }
      ]
    },
    social: {
      social_links: [
        { platform: 'linkedin', url: 'https://linkedin.com/in/yourname', username: 'yourname' },
        { platform: 'twitter', url: 'https://twitter.com/yourname', username: '@yourname' },
        { platform: 'instagram', url: 'https://instagram.com/yourname', username: '@yourname' },
        { platform: 'facebook', url: 'https://facebook.com/yourname', username: 'yourname' }
      ]
    },
    business_hours: {
      hours: [
        { day: 'monday', open_time: '09:00', close_time: '17:00', is_closed: false },
        { day: 'tuesday', open_time: '09:00', close_time: '17:00', is_closed: false },
        { day: 'wednesday', open_time: '09:00', close_time: '17:00', is_closed: false },
        { day: 'thursday', open_time: '09:00', close_time: '17:00', is_closed: false },
        { day: 'friday', open_time: '09:00', close_time: '17:00', is_closed: false }
      ]
    },
    testimonials: {
      reviews: [
        {
          client_name: 'Sarah Johnson',
          review: 'Exceptional work quality and professionalism. Delivered exactly what was promised on time and exceeded expectations.',
          rating: '5'
        },
        {
          client_name: 'Michael Chen',
          review: 'Outstanding communication throughout the project. Very knowledgeable and provided valuable insights.',
          rating: '5'
        },
        {
          client_name: 'Emily Rodriguez',
          review: 'Highly skilled professional who understands client needs perfectly. Would definitely work with again.',
          rating: '5'
        },
        {
          client_name: 'David Thompson',
          review: 'Impressive attention to detail and creative problem-solving. The results speak for themselves.',
          rating: '5'
        },
        {
          client_name: 'Lisa Park',
          review: 'Professional, reliable, and delivers high-quality work consistently. A pleasure to work with.',
          rating: '5'
        },
        {
          client_name: 'James Wilson',
          review: 'Excellent expertise and great communication skills. Made the entire process smooth and efficient.',
          rating: '5'
        }
      ]
    },
    appointments: {
      booking_url: 'https://calendly.com/yourname',
      calendar_link: 'https://calendar.google.com/yourname'
    },
    google_map: {
      map_embed_url: '',
      directions_url: 'https://maps.google.com/directions'
    },
    app_download: {
      app_store_url: '#',
      play_store_url: '#'
    },
    custom_html: {
      html_content: '<div class="custom-section"><h4>Additional Information</h4><p>Add any custom content here.</p></div>',
      section_title: 'Additional Info',
      show_title: true
    },
    qr_share: {
      enable_qr: true,
      qr_title: 'Share My Contact',
      qr_description: 'Scan this QR code to save my contact information.'
    },
    thank_you: {
      message: 'Thank you for your interest! I will get back to you soon.'
    },
    action_buttons: {
      contact_button_text: 'Contact Me',
      save_contact_button_text: 'Save Contact'
    },
    copyright: {
      text: '© 2025 Your Name. All rights reserved.'
    },
    contact_form: {
      form_title: 'Get In Touch',
      form_description: 'Feel free to reach out for any inquiries or collaboration opportunities.'
    },
    language: {
      template_language: 'en'
    }
  }
};