import { socialPlatformsConfig } from '../social-platforms-config';
import languageData from '@/../../resources/lang/language.json';

export const influencerTemplate = {
  name: 'Influencer',
  sections: [
    {
      key: 'header',
      name: 'Header',
      fields: [
        { name: 'name', type: 'text', label: 'Full Name' },
        { name: 'title', type: 'text', label: 'Influencer Title' },
        { name: 'tagline', type: 'textarea', label: 'Bio/Tagline' },
        { name: 'profile_image', type: 'file', label: 'Profile Image' }
      ],
      required: true
    },
    {
      key: 'contact',
      name: 'Contact Information',
      fields: [
        { name: 'email', type: 'email', label: 'Business Email' },
        { name: 'phone', type: 'tel', label: 'Phone Number' },
        { name: 'website', type: 'url', label: 'Website URL' },
        { name: 'location', type: 'text', label: 'Location' }
      ],
      required: true
    },
    {
      key: 'about',
      name: 'About',
      fields: [
        { name: 'description', type: 'textarea', label: 'About Me' },
        { name: 'niches', type: 'tags', label: 'Content Niches' },
        { name: 'experience', type: 'number', label: 'Years as Influencer' }
      ],
      required: false
    },
    {
      key: 'stats',
      name: 'Follower Stats',
      fields: [
        {
          name: 'platform_stats',
          type: 'repeater',
          label: 'Platform Statistics',
          fields: [
            { name: 'platform', type: 'select', label: 'Platform', options: [
              { value: 'instagram', label: 'Instagram' },
              { value: 'tiktok', label: 'TikTok' },
              { value: 'youtube', label: 'YouTube' },
              { value: 'twitter', label: 'Twitter/X' },
              { value: 'facebook', label: 'Facebook' },
              { value: 'linkedin', label: 'LinkedIn' },
              { value: 'twitch', label: 'Twitch' },
              { value: 'snapchat', label: 'Snapchat' }
            ]},
            { name: 'followers', type: 'text', label: 'Follower Count' },
            { name: 'engagement_rate', type: 'text', label: 'Engagement Rate' },
            { name: 'monthly_views', type: 'text', label: 'Monthly Views' }
          ]
        }
      ],
      required: false
    },
    {
      key: 'content',
      name: 'Content Showcase',
      fields: [
        {
          name: 'content_list',
          type: 'repeater',
          label: 'Featured Content',
          fields: [
            { name: 'title', type: 'text', label: 'Content Title' },
            { name: 'description', type: 'textarea', label: 'Content Description' },
            { name: 'content_type', type: 'select', label: 'Content Type', options: [
              { value: 'reel', label: 'Instagram Reel' },
              { value: 'tiktok', label: 'TikTok Video' },
              { value: 'youtube_video', label: 'YouTube Video' },
              { value: 'post', label: 'Social Media Post' },
              { value: 'story', label: 'Story Highlight' },
              { value: 'live', label: 'Live Stream' },
              { value: 'collaboration', label: 'Brand Collaboration' }
            ]},
            { name: 'embed_url', type: 'textarea', label: 'Content Embed URL' },
            { name: 'thumbnail', type: 'file', label: 'Content Thumbnail' },
            { name: 'views', type: 'text', label: 'View Count' },
            { name: 'engagement', type: 'text', label: 'Engagement Count' },
            { name: 'platform', type: 'text', label: 'Platform' }
          ]
        }
      ],
      required: false
    },
    {
      key: 'collaborations',
      name: 'Brand Collaborations',
      fields: [
        {
          name: 'brand_list',
          type: 'repeater',
          label: 'Brand Partnerships',
          fields: [
            { name: 'brand_name', type: 'text', label: 'Brand Name' },
            { name: 'campaign_type', type: 'select', label: 'Campaign Type', options: [
              { value: 'sponsored_post', label: 'Sponsored Post' },
              { value: 'product_review', label: 'Product Review' },
              { value: 'brand_ambassador', label: 'Brand Ambassador' },
              { value: 'giveaway', label: 'Giveaway/Contest' },
              { value: 'event', label: 'Event Coverage' },
              { value: 'unboxing', label: 'Unboxing Video' }
            ]},
            { name: 'description', type: 'textarea', label: 'Campaign Description' },
            { name: 'brand_logo', type: 'file', label: 'Brand Logo' },
            { name: 'campaign_url', type: 'url', label: 'Campaign URL' },
            { name: 'results', type: 'text', label: 'Campaign Results' }
          ]
        }
      ],
      required: false
    },
    {
      key: 'services',
      name: 'Influencer Services',
      fields: [
        {
          name: 'service_list',
          type: 'repeater',
          label: 'Services Offered',
          fields: [
            { name: 'title', type: 'text', label: 'Service Title' },
            { name: 'description', type: 'textarea', label: 'Service Description' },
            { name: 'price', type: 'text', label: 'Starting Price' },
            { name: 'deliverables', type: 'textarea', label: 'What\'s Included' }
          ]
        }
      ],
      required: false
    },
    {
      key: 'social',
      name: 'Social Media',
      fields: [
        {
          name: 'social_links',
          type: 'repeater',
          label: 'Social Media Links',
          fields: [
            { name: 'platform', type: 'select', label: 'Platform', options: socialPlatformsConfig.map(p => ({ value: p.value, label: p.label })) },
            { name: 'url', type: 'url', label: 'Profile URL' },
            { name: 'username', type: 'text', label: 'Username/Handle' },
            { name: 'follower_count', type: 'text', label: 'Follower Count' }
          ]
        }
      ],
      required: false
    },
    {
      key: 'media_kit',
      name: 'Media Kit',
      fields: [
        { name: 'media_kit_url', type: 'url', label: 'Media Kit Download URL' },
        { name: 'rate_card_url', type: 'url', label: 'Rate Card URL' },
        { name: 'portfolio_url', type: 'url', label: 'Portfolio URL' }
      ],
      required: false
    },
    {
      key: 'testimonials',
      name: 'Client Testimonials',
      fields: [
        {
          name: 'reviews',
          type: 'repeater',
          label: 'Brand Reviews',
          fields: [
            { name: 'brand_name', type: 'text', label: 'Brand Name' },
            { name: 'review', type: 'textarea', label: 'Review Text' },
            { name: 'rating', type: 'number', label: 'Rating (1-5)' },
            { name: 'campaign_type', type: 'text', label: 'Campaign Type' }
          ]
        }
      ],
      required: false
    },
    {
      key: 'booking',
      name: 'Collaboration Booking',
      fields: [
        { name: 'booking_url', type: 'url', label: 'Booking Calendar URL' },
        { name: 'contact_form_url', type: 'url', label: 'Contact Form URL' },
        { name: 'response_time', type: 'text', label: 'Response Time' }
      ],
      required: false
    },
    {
      key: 'custom_html',
      name: 'Custom HTML',
      fields: [
        { name: 'html_content', type: 'textarea', label: 'Custom HTML Code' },
        { name: 'section_title', type: 'text', label: 'Section Title' },
        { name: 'show_title', type: 'checkbox', label: 'Show Section Title' }
      ],
      required: false
    },
    {
      key: 'qr_share',
      name: 'QR Code Share',
      fields: [
        { name: 'enable_qr', type: 'checkbox', label: 'Enable QR Code Sharing' },
        { name: 'qr_title', type: 'text', label: 'QR Section Title' },
        { name: 'qr_description', type: 'textarea', label: 'QR Description' }
      ],
      required: false
    },
    {
      key: 'contact_form',
      name: 'Contact Form',
      fields: [
        { name: 'form_title', type: 'text', label: 'Form Title' },
        { name: 'form_description', type: 'textarea', label: 'Form Description' }
      ],
      required: false
    },
    {
      key: 'language',
      name: 'Language Settings',
      fields: [
        { name: 'enable_language_switcher', type: 'checkbox', label: 'Enable Language Switcher' },
        { name: 'template_language', type: 'select', label: 'Template Language', options: languageData.map(lang => ({ value: lang.code, label: `${String.fromCodePoint(...lang.countryCode.toUpperCase().split('').map(char => 127397 + char.charCodeAt()))} ${lang.name}` })) }
      ],
      required: false
    },
    {
      key: 'thank_you',
      name: 'Thank You Message',
      fields: [
        { name: 'message', type: 'textarea', label: 'Thank You Message' }
      ],
      required: false
    },
    {
      key: 'action_buttons',
      name: 'Action Buttons',
      fields: [
        { name: 'contact_button_text', type: 'text', label: 'Contact Button Text' },
        { name: 'collaboration_button_text', type: 'text', label: 'Collaboration Button Text' },
        { name: 'save_contact_button_text', type: 'text', label: 'Save Contact Button Text' }
      ],
      required: false
    },
    {
      key: 'copyright',
      name: 'Copyright',
      fields: [
        { name: 'text', type: 'text', label: 'Copyright Text' }
      ],
      required: false
    }
  ],
  colorPresets: [
    { name: 'Instagram Pink', primary: '#E1306C', secondary: '#F77737', accent: '#FCAF45', background: '#FAFAFA', text: '#262626', cardBg: '#FFFFFF' },
    { name: 'TikTok Vibes', primary: '#FF0050', secondary: '#00F2EA', accent: '#000000', background: '#FFFFFF', text: '#161823', cardBg: '#F8F8F8' },
    { name: 'YouTube Red', primary: '#FF0000', secondary: '#FF4444', accent: '#FFE6E6', background: '#FFFFFF', text: '#0F0F0F', cardBg: '#F9F9F9' },
    { name: 'Aesthetic Purple', primary: '#8B5A96', secondary: '#B19CD9', accent: '#E6D7FF', background: '#F5F3FF', text: '#4C1D95', cardBg: '#FFFFFF' },
    { name: 'Sunset Gradient', primary: '#FF6B6B', secondary: '#FFE66D', accent: '#FF8E53', background: '#FFF5F5', text: '#2D3748', cardBg: '#FFFFFF' },
    { name: 'Ocean Blue', primary: '#0077B6', secondary: '#00B4D8', accent: '#90E0EF', background: '#F0F9FF', text: '#03045E', cardBg: '#FFFFFF' },
    { name: 'Mint Fresh', primary: '#06D6A0', secondary: '#118AB2', accent: '#FFD166', background: '#F8FFFF', text: '#073B4C', cardBg: '#FFFFFF' },
    { name: 'Rose Gold', primary: '#E91E63', secondary: '#F8BBD9', accent: '#FCE4EC', background: '#FFF8F8', text: '#880E4F', cardBg: '#FFFFFF' },
    { name: 'Neon Green', primary: '#39FF14', secondary: '#32CD32', accent: '#98FB98', background: '#F0FFF0', text: '#006400', cardBg: '#FFFFFF' },
    { name: 'Dark Mode', primary: '#BB86FC', secondary: '#03DAC6', accent: '#CF6679', background: '#121212', text: '#FFFFFF', cardBg: '#1E1E1E' }
  ],
  fontOptions: [
    { name: 'Poppins', value: 'Poppins, -apple-system, BlinkMacSystemFont, sans-serif', weight: '300,400,500,600,700' },
    { name: 'Montserrat', value: 'Montserrat, -apple-system, BlinkMacSystemFont, sans-serif', weight: '400,500,600,700' },
    { name: 'Playfair Display', value: 'Playfair Display, Georgia, serif', weight: '400,500,600,700' },
    { name: 'Inter', value: 'Inter, -apple-system, BlinkMacSystemFont, sans-serif', weight: '400,500,600,700' },
    { name: 'Dancing Script', value: 'Dancing Script, cursive', weight: '400,500,600,700' }
  ],
  defaultColors: {
    primary: '#E1306C',
    secondary: '#F77737',
    accent: '#FCAF45',
    background: '#FAFAFA',
    text: '#262626',
    cardBg: '#FFFFFF',
    borderColor: '#DBDBDB',
    gradient: 'linear-gradient(45deg, #E1306C, #F77737, #FCAF45)'
  },
  defaultFont: 'Poppins, -apple-system, BlinkMacSystemFont, sans-serif',
  themeStyle: {
    layout: 'modern-grid',
    headerStyle: 'gradient',
    cardStyle: 'elevated',
    buttonStyle: 'rounded',
    iconStyle: 'filled',
    spacing: 'comfortable',
    shadows: 'soft',
    animations: 'smooth',
    backgroundPattern: 'subtle-dots',
    gradients: true,
    roundedCorners: true
  },
  defaultData: {
    header: {
      name: 'Alex Johnson',
      title: 'Lifestyle & Fashion Influencer',
      tagline: '✨ Creating authentic content that inspires | 📍 NYC | 💌 Collaborations welcome',
      profile_image: ''
    },
    contact: {
      email: 'hello@alexjohnson.com',
      phone: '+1 (555) 123-4567',
      website: 'https://alexjohnson.com',
      location: 'New York City, NY'
    },
    about: {
      description: 'Passionate content creator sharing lifestyle, fashion, and wellness tips with an engaged community. I love connecting with brands that align with my values and creating authentic content that resonates with my audience.',
      niches: 'Fashion, Lifestyle, Beauty, Wellness, Travel',
      experience: '3'
    },
    stats: {
      platform_stats: [
        { platform: 'instagram', followers: '125K', engagement_rate: '4.8%', monthly_views: '2.5M' },
        { platform: 'tiktok', followers: '89K', engagement_rate: '6.2%', monthly_views: '1.8M' },
        { platform: 'youtube', followers: '45K', engagement_rate: '3.5%', monthly_views: '800K' }
      ]
    },
    content: {
      content_list: [
        { title: 'Summer Fashion Haul', description: 'Latest summer trends and styling tips', content_type: 'reel', embed_url: '', thumbnail: '', views: '250K', engagement: '12K', platform: 'Instagram' },
        { title: 'Morning Routine GRWM', description: 'Get ready with me for a productive day', content_type: 'tiktok', embed_url: '', thumbnail: '', views: '180K', engagement: '15K', platform: 'TikTok' },
        { title: 'Brand Collaboration Review', description: 'Honest review of sustainable fashion brand', content_type: 'youtube_video', embed_url: '', thumbnail: '', views: '95K', engagement: '3.2K', platform: 'YouTube' }
      ]
    },
    collaborations: {
      brand_list: [
        { brand_name: 'Sustainable Fashion Co.', campaign_type: 'brand_ambassador', description: '6-month partnership promoting eco-friendly fashion', brand_logo: '', campaign_url: '', results: '25% increase in brand awareness' },
        { brand_name: 'Beauty Essentials', campaign_type: 'product_review', description: 'Skincare routine featuring new product line', brand_logo: '', campaign_url: '', results: '150K+ views, 8% engagement' },
        { brand_name: 'Wellness Brand', campaign_type: 'sponsored_post', description: 'Promoting healthy lifestyle products', brand_logo: '', campaign_url: '', results: '200K+ reach, 12K+ engagements' }
      ]
    },
    services: {
      service_list: [
        { title: 'Instagram Sponsored Post', description: 'High-quality feed post with authentic storytelling', price: 'From $500', deliverables: '1 feed post, 3 stories, usage rights' },
        { title: 'TikTok Video Creation', description: 'Engaging short-form video content', price: 'From $750', deliverables: '1 TikTok video, cross-posting rights' },
        { title: 'Brand Ambassador Program', description: 'Long-term partnership with multiple touchpoints', price: 'Custom pricing', deliverables: 'Monthly content, stories, reels, events' },
        { title: 'Product Photography', description: 'Professional product shots for your brand', price: 'From $300', deliverables: '10 high-res images, editing included' }
      ]
    },
    social: {
      social_links: [
        { platform: 'instagram', url: 'https://instagram.com/alexjohnson', username: '@alexjohnson', follower_count: '125K' },
        { platform: 'tiktok', url: 'https://tiktok.com/@alexjohnson', username: '@alexjohnson', follower_count: '89K' },
        { platform: 'youtube', url: 'https://youtube.com/alexjohnson', username: 'Alex Johnson', follower_count: '45K' },
        { platform: 'twitter', url: 'https://twitter.com/alexjohnson', username: '@alexjohnson', follower_count: '28K' }
      ]
    },
    media_kit: {
      media_kit_url: 'https://alexjohnson.com/media-kit.pdf',
      rate_card_url: 'https://alexjohnson.com/rates.pdf',
      portfolio_url: 'https://alexjohnson.com/portfolio'
    },
    testimonials: {
      reviews: [
        { brand_name: 'Fashion Forward Inc.', review: 'Alex delivered exceptional content that perfectly captured our brand essence. The engagement was outstanding!', rating: '5', campaign_type: 'Brand Ambassador' },
        { brand_name: 'Beauty Collective', review: 'Professional, creative, and authentic. Alex exceeded our expectations with the campaign results.', rating: '5', campaign_type: 'Product Review' },
        { brand_name: 'Lifestyle Brand Co.', review: 'Amazing to work with! Alex understood our vision and created content that truly resonated with our target audience.', rating: '5', campaign_type: 'Sponsored Content' }
      ]
    },
    booking: {
      booking_url: 'https://calendly.com/alexjohnson',
      contact_form_url: 'https://alexjohnson.com/contact',
      response_time: 'Within 24 hours'
    },
    contact_form: {
      form_title: 'Let\'s Collaborate!',
      form_description: 'Ready to create amazing content together? Reach out and let\'s discuss your brand collaboration ideas.'
    },
    thank_you: {
      message: 'Thank you for reaching out! I\'m excited about potential collaborations and will get back to you within 24 hours.'
    },
    custom_html: {
      html_content: '<div class=\"featured-section\"><h4>Featured In</h4><p>Vogue, Elle, Harper\'s Bazaar, and more...</p></div>',
      section_title: 'Press & Features',
      show_title: true
    },
    qr_share: {
      enable_qr: true,
      qr_title: 'Connect With Me',
      qr_description: 'Scan to follow me on all platforms and stay updated with my latest content!'
    },
    language: {
      template_language: 'en',
      enable_language_switcher: true
    },
    action_buttons: {
      contact_button_text: 'Let\'s Collaborate ✨',
      collaboration_button_text: 'Book Partnership 📝',
      save_contact_button_text: 'Save Contact'
    },
    copyright: {
      text: '© 2025 Alex Johnson. All rights reserved.'
    }
  }
};