import { socialPlatformsConfig } from '../social-platforms-config';
import languageData from '@/../../resources/lang/language.json';

export const hotelResortsTemplate = {
  name: 'Hotel & Resorts',
  sections: [
    {
      key: 'header',
      name: 'Header',
      fields: [
        { name: 'name', type: 'text', label: 'Hotel/Resort Name' },
        { name: 'title', type: 'text', label: 'Property Type' },
        { name: 'tagline', type: 'textarea', label: 'Welcome Message' },
        { name: 'profile_image', type: 'file', label: 'Property Logo' }
      ],
      required: true
    },
    {
      key: 'contact',
      name: 'Contact Information',
      fields: [
        { name: 'email', type: 'email', label: 'Reservations Email' },
        { name: 'phone', type: 'tel', label: 'Phone Number' },
        { name: 'website', type: 'url', label: 'Website URL' },
        { name: 'location', type: 'text', label: 'Property Address' }
      ],
      required: true
    },
    {
      key: 'about',
      name: 'About Property',
      fields: [
        { name: 'description', type: 'textarea', label: 'Property Description' },
        { name: 'amenities', type: 'tags', label: 'Key Amenities' },
        { name: 'star_rating', type: 'number', label: 'Star Rating (1-5)' },
        { name: 'established_year', type: 'number', label: 'Established Year' }
      ],
      required: false
    },
    {
      key: 'rooms',
      name: 'Rooms & Suites',
      fields: [
        {
          name: 'room_types',
          type: 'repeater',
          label: 'Room Categories',
          fields: [
            { name: 'room_name', type: 'text', label: 'Room Type' },
            { name: 'description', type: 'textarea', label: 'Room Description' },
            { name: 'price_from', type: 'number', label: 'Price From' },
            { name: 'max_occupancy', type: 'number', label: 'Max Occupancy' },
            { name: 'room_image', type: 'file', label: 'Room Image' }
          ]
        }
      ],
      required: false
    },
    {
      key: 'videos',
      name: 'Property Videos',
      fields: [
        {
          name: 'video_list',
          type: 'repeater',
          label: 'Hotel Content',
          fields: [
            { name: 'title', type: 'text', label: 'Video Title' },
            { name: 'description', type: 'textarea', label: 'Video Description' },
            { name: 'video_type', type: 'select', label: 'Video Type', options: [
              { value: 'property_tour', label: 'Property Tour' },
              { value: 'room_showcase', label: 'Room Showcase' },
              { value: 'amenities_tour', label: 'Amenities Tour' },
              { value: 'guest_testimonial', label: 'Guest Testimonial' },
              { value: 'dining_experience', label: 'Dining Experience' },
              { value: 'local_attractions', label: 'Local Attractions' }
            ]},
            { name: 'embed_url', type: 'textarea', label: 'Video Embed URL' },
            { name: 'thumbnail', type: 'file', label: 'Video Thumbnail' },
            { name: 'duration', type: 'text', label: 'Duration' }
          ]
        }
      ],
      required: false
    },
    {
      key: 'youtube',
      name: 'YouTube Channel',
      fields: [
        { name: 'channel_url', type: 'url', label: 'YouTube Channel URL' },
        { name: 'channel_name', type: 'text', label: 'Channel Name' },
        { name: 'subscriber_count', type: 'text', label: 'Subscriber Count' },
        { name: 'featured_playlist', type: 'url', label: 'Featured Playlist URL' },
        { name: 'latest_video_embed', type: 'textarea', label: 'Latest Video Embed Code' },
        { name: 'channel_description', type: 'textarea', label: 'Channel Description' }
      ],
      required: false
    },
    {
      key: 'dining',
      name: 'Dining & Restaurants',
      fields: [
        {
          name: 'restaurants',
          type: 'repeater',
          label: 'Dining Options',
          fields: [
            { name: 'restaurant_name', type: 'text', label: 'Restaurant Name' },
            { name: 'cuisine_type', type: 'text', label: 'Cuisine Type' },
            { name: 'description', type: 'textarea', label: 'Description' },
            { name: 'operating_hours', type: 'text', label: 'Operating Hours' }
          ]
        }
      ],
      required: false
    },
    {
      key: 'gallery',
      name: 'Photo Gallery',
      fields: [
        {
          name: 'photos',
          type: 'repeater',
          label: 'Property Photos',
          fields: [
            { name: 'title', type: 'text', label: 'Photo Title' },
            { name: 'image', type: 'file', label: 'Photo' },
            { name: 'category', type: 'select', label: 'Category', options: [
              { value: 'exterior', label: 'Exterior' },
              { value: 'rooms', label: 'Rooms' },
              { value: 'dining', label: 'Dining' },
              { value: 'amenities', label: 'Amenities' },
              { value: 'events', label: 'Events' }
            ]}
          ]
        }
      ],
      required: false
    },
    {
      key: 'social',
      name: 'Social Media',
      fields: [
        {
          name: 'social_links',
          type: 'repeater',
          label: 'Social Media Links',
          fields: [
            { name: 'platform', type: 'select', label: 'Platform', options: socialPlatformsConfig.map(p => ({ value: p.value, label: p.label })) },
            { name: 'url', type: 'url', label: 'Profile URL' },
            { name: 'username', type: 'text', label: 'Username/Handle' }
          ]
        }
      ],
      required: false
    },
    {
      key: 'business_hours',
      name: 'Operating Hours',
      fields: [
        {
          name: 'hours',
          type: 'repeater',
          label: 'Reception Hours',
          fields: [
            { name: 'day', type: 'select', label: 'Day', options: [
              { value: 'monday', label: 'Monday' },
              { value: 'tuesday', label: 'Tuesday' },
              { value: 'wednesday', label: 'Wednesday' },
              { value: 'thursday', label: 'Thursday' },
              { value: 'friday', label: 'Friday' },
              { value: 'saturday', label: 'Saturday' },
              { value: 'sunday', label: 'Sunday' }
            ]},
            { name: 'open_time', type: 'time', label: 'Opening Time' },
            { name: 'close_time', type: 'time', label: 'Closing Time' },
            { name: 'is_closed', type: 'checkbox', label: 'Closed' }
          ]
        }
      ],
      required: false
    },
    {
      key: 'appointments',
      name: 'Reservations',
      fields: [
        { name: 'booking_url', type: 'url', label: 'Online Booking URL' },
        { name: 'reservation_phone', type: 'tel', label: 'Reservation Phone' },
        { name: 'booking_email', type: 'email', label: 'Booking Email' }
      ],
      required: false
    },
    {
      key: 'testimonials',
      name: 'Guest Reviews',
      fields: [
        {
          name: 'reviews',
          type: 'repeater',
          label: 'Guest Testimonials',
          fields: [
            { name: 'guest_name', type: 'text', label: 'Guest Name' },
            { name: 'review', type: 'textarea', label: 'Review Text' },
            { name: 'rating', type: 'number', label: 'Rating (1-5)' },
            { name: 'stay_date', type: 'text', label: 'Stay Date' }
          ]
        }
      ],
      required: false
    },
    {
      key: 'google_map',
      name: 'Location',
      fields: [
        { name: 'map_embed_url', type: 'textarea', label: 'Google Maps Embed URL' },
        { name: 'directions_url', type: 'url', label: 'Google Maps Directions URL' }
      ],
      required: false
    },
    {
      key: 'app_download',
      name: 'App Download',
      fields: [
        { name: 'app_store_url', type: 'url', label: 'App Store URL' },
        { name: 'play_store_url', type: 'url', label: 'Play Store URL' }
      ],
      required: false
    },
    {
      key: 'custom_html',
      name: 'Custom HTML',
      fields: [
        { name: 'html_content', type: 'textarea', label: 'Custom HTML Code' },
        { name: 'section_title', type: 'text', label: 'Section Title' },
        { name: 'show_title', type: 'checkbox', label: 'Show Section Title' }
      ],
      required: false
    },
    {
      key: 'qr_share',
      name: 'QR Code Share',
      fields: [
        { name: 'enable_qr', type: 'checkbox', label: 'Enable QR Code Sharing' },
        { name: 'qr_title', type: 'text', label: 'QR Section Title' },
        { name: 'qr_description', type: 'textarea', label: 'QR Description' },
        { name: 'qr_size', type: 'select', label: 'QR Code Size', options: [
          { value: 'small', label: 'Small (128px)' },
          { value: 'medium', label: 'Medium (200px)' },
          { value: 'large', label: 'Large (300px)' }
        ]}
      ],
      required: false
    },
    {
      key: 'contact_form',
      name: 'Contact Form',
      fields: [
        { name: 'form_title', type: 'text', label: 'Form Title' },
        { name: 'form_description', type: 'textarea', label: 'Form Description' }
      ],
      required: false
    },
    {
      key: 'language',
      name: 'Language Settings',
      fields: [
        { name: 'enable_language_switcher', type: 'checkbox', label: 'Enable Language Switcher' },
        { name: 'template_language', type: 'select', label: 'Template Language', options: languageData.map(lang => ({ value: lang.code, label: `${String.fromCodePoint(...lang.countryCode.toUpperCase().split('').map(char => 127397 + char.charCodeAt()))} ${lang.name}` })) }
      ],
      required: false
    },
    {
      key: 'thank_you',
      name: 'Thank You Message',
      fields: [
        { name: 'message', type: 'textarea', label: 'Thank You Message' }
      ],
      required: false
    },
    {
      key: 'action_buttons',
      name: 'Action Buttons',
      fields: [
        { name: 'contact_button_text', type: 'text', label: 'Contact Button Text' },
        { name: 'appointment_button_text', type: 'text', label: 'Reservation Button Text' },
        { name: 'save_contact_button_text', type: 'text', label: 'Save Contact Button Text' }
      ],
      required: false
    },
    {
      key: 'copyright',
      name: 'Copyright',
      fields: [
        { name: 'text', type: 'text', label: 'Copyright Text' }
      ],
      required: false
    },
    {
      key: 'seo',
      name: 'SEO Settings',
      fields: [
        { name: 'meta_title', type: 'text', label: 'Meta Title' },
        { name: 'meta_description', type: 'textarea', label: 'Meta Description' },
        { name: 'keywords', type: 'text', label: 'Keywords' },
        { name: 'og_image', type: 'url', label: 'Open Graph Image URL' }
      ],
      required: false
    },
    {
      key: 'pixels',
      name: 'Pixel & Analytics',
      fields: [
        { name: 'google_analytics', type: 'text', label: 'Google Analytics ID' },
        { name: 'facebook_pixel', type: 'text', label: 'Facebook Pixel ID' },
        { name: 'gtm_id', type: 'text', label: 'Google Tag Manager ID' },
        { name: 'custom_head', type: 'textarea', label: 'Custom Head Code' },
        { name: 'custom_body', type: 'textarea', label: 'Custom Body Code' }
      ],
      required: false
    },
    {
      key: 'footer',
      name: 'Footer',
      fields: [
        { name: 'show_footer', type: 'checkbox', label: 'Show Footer' },
        { name: 'footer_text', type: 'textarea', label: 'Footer Text' },
        { name: 'footer_links', type: 'repeater', label: 'Footer Links', fields: [
          { name: 'title', type: 'text', label: 'Link Title' },
          { name: 'url', type: 'url', label: 'Link URL' }
        ]}
      ],
      required: false
    }
  ],
  colorPresets: [
    { name: 'Luxury Gold', primary: '#B8860B', secondary: '#DAA520', accent: '#FFF8DC', background: '#FFFFFF', text: '#2C2C2C', cardBg: '#F8F9FA'},
    { name: 'Ocean Blue', primary: '#006994', secondary: '#4A90A4', accent: '#E6F3F7', background: '#F0F8FF', text: '#1E3A8A', cardBg: '#FFFFFF' },
    { name: 'Resort Green', primary: '#228B22', secondary: '#32CD32', accent: '#F0FFF0', background: '#F5F5DC', text: '#006400', cardBg: '#FFFFFF' },
    { name: 'Sunset Orange', primary: '#FF4500', secondary: '#FF7F50', accent: '#FFF8DC', background: '#FFFFFF', text: '#2C2C2C', cardBg: '#FFF5EE' },
    { name: 'Royal Purple', primary: '#663399', secondary: '#9966CC', accent: '#F3E5F5', background: '#FAFAFA', text: '#4A148C', cardBg: '#FFFFFF' }
  ],
  fontOptions: [
    { name: 'Playfair Display', value: 'Playfair Display, Georgia, serif', weight: '400,500,600,700' },
    { name: 'Inter', value: 'Inter, -apple-system, BlinkMacSystemFont, sans-serif', weight: '400,500,600,700' },
    { name: 'Crimson Text', value: 'Crimson Text, Georgia, serif', weight: '400,600,700' },
    { name: 'Lora', value: 'Lora, Georgia, serif', weight: '400,500,600,700' },
    { name: 'Montserrat', value: 'Montserrat, -apple-system, BlinkMacSystemFont, sans-serif', weight: '400,500,600,700' }
  ],
  defaultColors: {
    primary: '#B8860B',
    secondary: '#DAA520',
    accent: '#FFF8DC',
    background: '#FFFFFF',
    text: '#2C2C2C',
    cardBg: '#F8F9FA',
    borderColor: '#A67C52',
    buttonText: '#FFFFFF',
    highlightColor: '#228B22'
  },
  defaultFont: 'Inter, -apple-system, BlinkMacSystemFont, sans-serif',
  themeStyle: {
    layout: 'hotel-showcase',
    headerStyle: 'hero-banner',
    cardStyle: 'hospitality-cards',
    buttonStyle: 'reservation-cta',
    iconStyle: 'hotel-amenities',
    spacing: 'resort-layout',
    shadows: 'luxury-depth',
    animations: 'parallax-scroll',
    backgroundPattern: 'marble-texture',
    typography: 'luxury-serif'
  },
  defaultData: {
    header: {
      name: 'Grand Paradise Resort',
      title: '5-Star Luxury Resort',
      tagline: 'Experience unparalleled luxury and comfort in paradise',
      profile_image: ''
    },
    contact: {
      email: 'reservations@grandparadise.com',
      phone: '+1 (555) 123-STAY',
      website: 'https://grandparadiseresort.com',
      location: 'Paradise Island, Bahamas'
    },
    about: {
      description: 'Nestled on pristine white sand beaches, Grand Paradise Resort offers world-class amenities, exceptional service, and unforgettable experiences for discerning travelers.',
      amenities: 'Private Beach, Spa, Pool, Restaurant, Bar, Gym, WiFi, Concierge',
      star_rating: '5',
      established_year: '1995'
    },
    rooms: {
      room_types: [
        { room_name: 'Ocean View Suite', description: 'Luxurious suite with panoramic ocean views', price_from: '450', max_occupancy: '4', room_image: '' },
        { room_name: 'Beachfront Villa', description: 'Private villa steps from the beach', price_from: '850', max_occupancy: '6', room_image: '' },
        { room_name: 'Presidential Suite', description: 'Ultimate luxury with private butler service', price_from: '1200', max_occupancy: '8', room_image: '' }
      ]
    },
    videos: {
      video_list: [
        { title: 'Resort Virtual Tour', description: 'Take a virtual tour of our stunning property and amenities', video_type: 'property_tour', embed_url: '', thumbnail: '', duration: '3:45' },
        { title: 'Ocean View Suite Showcase', description: 'Explore our luxurious ocean view accommodations', video_type: 'room_showcase', embed_url: '', thumbnail: '', duration: '2:30' },
        { title: 'Guest Experience Testimonial', description: 'Hear from our satisfied guests about their stay', video_type: 'guest_testimonial', embed_url: '', thumbnail: '', duration: '1:45' }
      ]
    },
    youtube: {
      channel_url: 'https://youtube.com/grandparadiseresort',
      channel_name: 'Grand Paradise Resort',
      subscriber_count: '25.3K',
      featured_playlist: 'https://youtube.com/playlist?list=PLresortexperiences',
      latest_video_embed: '',
      channel_description: 'Discover luxury travel experiences, resort tours, and guest stories from Grand Paradise Resort. Subscribe for exclusive content and travel inspiration.'
    },
    dining: {
      restaurants: [
        { restaurant_name: 'Azure Restaurant', cuisine_type: 'Fine Dining', description: 'Award-winning cuisine with ocean views', operating_hours: '6:00 PM - 11:00 PM' },
        { restaurant_name: 'Poolside Grill', cuisine_type: 'Casual Dining', description: 'Fresh grilled specialties by the pool', operating_hours: '11:00 AM - 10:00 PM' },
        { restaurant_name: 'Sunset Lounge', cuisine_type: 'Bar & Cocktails', description: 'Craft cocktails with stunning sunset views', operating_hours: '4:00 PM - 2:00 AM' }
      ]
    },
    gallery: {
      photos: [
        { title: 'Resort Exterior', image: '', category: 'exterior' },
        { title: 'Ocean View Suite', image: '', category: 'rooms' },
        { title: 'Azure Restaurant', image: '', category: 'dining' },
        { title: 'Infinity Pool', image: '', category: 'amenities' }
      ]
    },
    social: {
      social_links: [
        { platform: 'instagram', url: 'https://instagram.com/grandparadise', username: '@grandparadise' },
        { platform: 'facebook', url: 'https://facebook.com/grandparadiseresort', username: 'Grand Paradise Resort' },
        { platform: 'twitter', url: 'https://twitter.com/grandparadise', username: '@grandparadise' },
        { platform: 'youtube', url: 'https://youtube.com/grandparadiseresort', username: 'Grand Paradise Resort' }
      ]
    },
    business_hours: {
      hours: [
        { day: 'monday', open_time: '00:00', close_time: '23:59', is_closed: false },
        { day: 'tuesday', open_time: '00:00', close_time: '23:59', is_closed: false },
        { day: 'wednesday', open_time: '00:00', close_time: '23:59', is_closed: false },
        { day: 'thursday', open_time: '00:00', close_time: '23:59', is_closed: false },
        { day: 'friday', open_time: '00:00', close_time: '23:59', is_closed: false },
        { day: 'saturday', open_time: '00:00', close_time: '23:59', is_closed: false },
        { day: 'sunday', open_time: '00:00', close_time: '23:59', is_closed: false }
      ]
    },
    appointments: {
      booking_url: 'https://grandparadise.com/book',
      reservation_phone: '+1 (555) 123-STAY',
      booking_email: 'reservations@grandparadise.com'
    },
    testimonials: {
      reviews: [
        { guest_name: 'Sarah & Michael', review: 'Absolutely magical stay! The service was impeccable and the views were breathtaking.', rating: '5', stay_date: 'December 2024' },
        { guest_name: 'The Johnson Family', review: 'Perfect family vacation. The kids loved the pool and we enjoyed the spa.', rating: '5', stay_date: 'November 2024' },
        { guest_name: 'David Chen', review: 'Outstanding resort with world-class amenities. Will definitely return!', rating: '5', stay_date: 'October 2024' }
      ]
    },
    google_map: {
      map_embed_url: '',
      directions_url: 'https://maps.google.com/directions'
    },
    app_download: {
      app_store_url: '#',
      play_store_url: '#'
    },
    contact_form: {
      form_title: 'Plan Your Stay',
      form_description: 'Ready to experience paradise? Contact us to plan your perfect getaway.'
    },
    thank_you: {
      message: 'Thank you for your interest in Grand Paradise Resort! We will contact you within 24 hours to assist with your reservation.'
    },
    seo: {
      meta_title: 'Grand Paradise Resort - 5-Star Luxury Resort in Paradise',
      meta_description: 'Experience luxury at Grand Paradise Resort. 5-star accommodations, world-class amenities, and pristine beaches await.',
      keywords: 'luxury resort, 5-star hotel, paradise island, beach resort, vacation, spa, fine dining',
      og_image: ''
    },
    pixels: {
      google_analytics: '',
      facebook_pixel: '',
      gtm_id: '',
      custom_head: '',
      custom_body: ''
    },
    custom_html: {
      html_content: '<div class="custom-section"><h4>Special Offers</h4><p>Book direct and save up to 20% on your stay. Includes complimentary breakfast and spa credits.</p></div>',
      section_title: 'Special Offers',
      show_title: true
    },
    qr_share: {
      enable_qr: true,
      qr_title: 'Share Resort Info',
      qr_description: 'Scan this QR code to share our resort information with friends and family.',
      qr_size: 'medium'
    },
    language: {
      template_language: 'en',
      enable_language_switcher: true
    },
    action_buttons: {
      contact_button_text: 'Contact Resort',
      appointment_button_text: 'Book Your Stay',
      save_contact_button_text: 'Save Contact'
    },
    footer: {
      show_footer: true,
      footer_text: 'Experience the ultimate in luxury and relaxation at Grand Paradise Resort. Your perfect getaway awaits.',
      footer_links: [
        { title: 'View Rooms', url: '#rooms' },
        { title: 'Make Reservation', url: '#booking' },
        { title: 'Resort Amenities', url: '#amenities' },
        { title: 'Contact Us', url: '#contact' }
      ]
    },
    copyright: {
      text: '© 2025 Grand Paradise Resort. All rights reserved.'
    }
  }
};