import { socialPlatformsConfig } from '../social-platforms-config';
import languageData from '@/../../resources/lang/language.json';

export const actorTemplate = {
  name: 'Actor',
  sections: [
    {
      key: 'header',
      name: 'Header',
      fields: [
        { name: 'name', type: 'text', label: 'Full Name' },
        { name: 'title', type: 'text', label: 'Professional Title' },
        { name: 'tagline', type: 'textarea', label: 'Tagline' },
        { name: 'profile_image', type: 'file', label: 'Profile Image' },
        { name: 'banner_image', type: 'file', label: 'Banner Background Image' },
        { name: 'banner_bg_image', type: 'file', label: 'Banner Overlay Image' }
      ],
      required: true
    },
    {
      key: 'contact',
      name: 'Contact Information',
      fields: [
        { name: 'email', type: 'email', label: 'Email Address' },
        { name: 'phone', type: 'tel', label: 'Phone Number' },
        { name: 'website', type: 'url', label: 'Website URL' },
        { name: 'location', type: 'text', label: 'Location' }
      ],
      required: true
    },
    {
      key: 'about',
      name: 'About',
      fields: [
        { name: 'description', type: 'textarea', label: 'About Me' },
        { name: 'experience', type: 'number', label: 'Years of Experience' },
        { name: 'specialties', type: 'tags', label: 'Acting Specialties' }
      ],
      required: false
    },
    {
      key: 'gallery',
      name: 'Gallery',
      fields: [
        {
          name: 'media_list',
          type: 'repeater',
          label: 'Photos & Videos',
          fields: [
            { name: 'title', type: 'text', label: 'Media Title' },
            { name: 'type', type: 'select', label: 'Media Type', options: [
              { value: 'image', label: 'Image' },
              { value: 'video', label: 'Video' }
            ]},
            { name: 'image', type: 'file', label: 'Image File' },
            { name: 'video_url', type: 'url', label: 'Video URL' },
            { name: 'thumbnail', type: 'file', label: 'Video Thumbnail' }
          ]
        }
      ],
      required: false
    },
    {
      key: 'services',
      name: 'Services',
      fields: [
        {
          name: 'service_list',
          type: 'repeater',
          label: 'Acting Services',
          fields: [
            { name: 'title', type: 'text', label: 'Service Title' },
            { name: 'description', type: 'textarea', label: 'Description' },
            { name: 'image', type: 'file', label: 'Service Image' },
            { name: 'url', type: 'url', label: 'More Info URL' }
          ]
        }
      ],
      required: false
    },
    {
      key: 'social',
      name: 'Social Media',
      fields: [
        {
          name: 'social_links',
          type: 'repeater',
          label: 'Social Media Links',
          fields: [
            { name: 'platform', type: 'select', label: 'Platform', options: socialPlatformsConfig.map(p => ({ value: p.value, label: p.label })) },
            { name: 'url', type: 'url', label: 'Profile URL' },
            { name: 'username', type: 'text', label: 'Username/Handle' }
          ]
        }
      ],
      required: false
    },
    {
      key: 'business_hours',
      name: 'Availability Hours',
      fields: [
        {
          name: 'hours',
          type: 'repeater',
          label: 'Availability Hours',
          fields: [
            { name: 'day', type: 'select', label: 'Day', options: [
              { value: 'monday', label: 'Monday' },
              { value: 'tuesday', label: 'Tuesday' },
              { value: 'wednesday', label: 'Wednesday' },
              { value: 'thursday', label: 'Thursday' },
              { value: 'friday', label: 'Friday' },
              { value: 'saturday', label: 'Saturday' },
              { value: 'sunday', label: 'Sunday' }
            ]},
            { name: 'open_time', type: 'time', label: 'Available From' },
            { name: 'close_time', type: 'time', label: 'Available Until' },
            { name: 'is_closed', type: 'checkbox', label: 'Not Available' }
          ]
        }
      ],
      required: false
    },
    {
      key: 'appointments',
      name: 'Appointments',
      fields: [
        { name: 'booking_url', type: 'url', label: 'Booking URL' },
        { name: 'calendar_link', type: 'url', label: 'Calendar Link' },
        { name: 'appointment_title', type: 'text', label: 'Appointment Section Title' }
      ],
      required: false
    },
    {
      key: 'testimonials',
      name: 'Testimonials',
      fields: [
        {
          name: 'reviews',
          type: 'repeater',
          label: 'Client Reviews',
          fields: [
            { name: 'client_name', type: 'text', label: 'Client Name' },
            { name: 'review', type: 'textarea', label: 'Review Text' },
            { name: 'rating', type: 'number', label: 'Rating (1-5)' },
            { name: 'client_image', type: 'file', label: 'Client Photo' }
          ]
        }
      ],
      required: false
    },
    {
      key: 'google_map',
      name: 'Location',
      fields: [
        { name: 'map_embed_url', type: 'textarea', label: 'Google Maps Embed URL' },
        { name: 'directions_url', type: 'url', label: 'Google Maps Directions URL' }
      ],
      required: false
    },
    {
      key: 'app_download',
      name: 'App Download',
      fields: [
        { name: 'app_store_url', type: 'url', label: 'App Store URL' },
        { name: 'play_store_url', type: 'url', label: 'Play Store URL' }
      ],
      required: false
    },
    {
      key: 'custom_html',
      name: 'Custom HTML',
      fields: [
        { name: 'html_content', type: 'textarea', label: 'Custom HTML Code' },
        { name: 'section_title', type: 'text', label: 'Section Title' },
        { name: 'show_title', type: 'checkbox', label: 'Show Section Title' }
      ],
      required: false
    },
    {
      key: 'qr_share',
      name: 'QR Code Share',
      fields: [
        { name: 'enable_qr', type: 'checkbox', label: 'Enable QR Code Sharing' },
        { name: 'qr_title', type: 'text', label: 'QR Section Title' },
        { name: 'qr_description', type: 'textarea', label: 'QR Description' },
        { name: 'qr_size', type: 'select', label: 'QR Code Size', options: [
          { value: 'small', label: 'Small (128px)' },
          { value: 'medium', label: 'Medium (200px)' },
          { value: 'large', label: 'Large (300px)' }
        ]}
      ],
      required: false
    },
    {
      key: 'contact_form',
      name: 'Contact Form',
      fields: [
        { name: 'form_title', type: 'text', label: 'Form Title' },
        { name: 'form_description', type: 'textarea', label: 'Form Description' }
      ],
      required: false
    },
    {
      key: 'language',
      name: 'Language Settings',
      fields: [
        { name: 'enable_language_switcher', type: 'checkbox', label: 'Enable Language Switcher' },
        { name: 'template_language', type: 'select', label: 'Template Language', options: languageData.map(lang => ({ value: lang.code, label: `${String.fromCodePoint(...lang.countryCode.toUpperCase().split('').map(char => 127397 + char.charCodeAt()))} ${lang.name}` })) }
      ],
      required: false
    },
    {
      key: 'thank_you',
      name: 'Thank You Message',
      fields: [
        { name: 'message', type: 'textarea', label: 'Thank You Message' }
      ],
      required: false
    },
    {
      key: 'action_buttons',
      name: 'Action Buttons',
      fields: [
        { name: 'contact_button_text', type: 'text', label: 'Contact Button Text' },
        { name: 'appointment_button_text', type: 'text', label: 'Appointment Button Text' },
        { name: 'save_contact_button_text', type: 'text', label: 'Save Contact Button Text' },
        { name: 'share_button_text', type: 'text', label: 'Share Button Text' }
      ],
      required: false
    },
    {
      key: 'copyright',
      name: 'Copyright',
      fields: [
        { name: 'text', type: 'text', label: 'Copyright Text' }
      ],
      required: false
    },
    {
      key: 'seo',
      name: 'SEO Settings',
      fields: [
        { name: 'meta_title', type: 'text', label: 'Meta Title' },
        { name: 'meta_description', type: 'textarea', label: 'Meta Description' },
        { name: 'keywords', type: 'text', label: 'Keywords' },
        { name: 'og_image', type: 'url', label: 'Open Graph Image URL' }
      ],
      required: false
    },
    {
      key: 'pixels',
      name: 'Pixel & Analytics',
      fields: [
        { name: 'google_analytics', type: 'text', label: 'Google Analytics ID' },
        { name: 'facebook_pixel', type: 'text', label: 'Facebook Pixel ID' },
        { name: 'gtm_id', type: 'text', label: 'Google Tag Manager ID' },
        { name: 'custom_head', type: 'textarea', label: 'Custom Head Code' },
        { name: 'custom_body', type: 'textarea', label: 'Custom Body Code' }
      ],
      required: false
    },
    {
      key: 'footer',
      name: 'Footer',
      fields: [
        { name: 'show_footer', type: 'checkbox', label: 'Show Footer' },
        { name: 'footer_text', type: 'textarea', label: 'Footer Text' },
        { name: 'footer_links', type: 'repeater', label: 'Footer Links', fields: [
          { name: 'title', type: 'text', label: 'Link Title' },
          { name: 'url', type: 'url', label: 'Link URL' }
        ]}
      ],
      required: false
    }
  ],
  colorPresets: [
    { name: 'Classic Actor', primary: '#460B0D', secondary: '#F2F2F2', accent: '#881346', background: '#FFFFFF', text: '#111111', cardBg: '#F2F2F2' },
    { name: 'Broadway Red', primary: '#DC143C', secondary: '#FFE4E1', accent: '#B22222', background: '#FFFFFF', text: '#000000', cardBg: '#FFF8F8' },
    { name: 'Elegant Purple', primary: '#6A0DAD', secondary: '#E6E6FA', accent: '#4B0082', background: '#FFFFFF', text: '#2F2F2F', cardBg: '#F8F8FF' },
    { name: 'Modern Teal', primary: '#008B8B', secondary: '#E0FFFF', accent: '#20B2AA', background: '#FFFFFF', text: '#2F4F4F', cardBg: '#F0FFFF' },
    { name: 'Vintage Brown', primary: '#8B4513', secondary: '#F5DEB3', accent: '#A0522D', background: '#FFF8DC', text: '#654321', cardBg: '#FAEBD7' },
    { name: 'Royal Blue', primary: '#4169E1', secondary: '#E6F3FF', accent: '#1E90FF', background: '#FFFFFF', text: '#191970', cardBg: '#F0F8FF' },
    { name: 'Forest Green', primary: '#228B22', secondary: '#F0FFF0', accent: '#32CD32', background: '#FFFFFF', text: '#006400', cardBg: '#F5FFFA' }
  ],
  fontOptions: [
    { name: 'Lora', value: 'Lora, serif', weight: '400,500,600,700' },
    { name: 'Playfair Display', value: 'Playfair Display, serif', weight: '400,500,600,700' },
    { name: 'Crimson Text', value: 'Crimson Text, serif', weight: '400,600,700' },
    { name: 'Libre Baskerville', value: 'Libre Baskerville, serif', weight: '400,700' },
    { name: 'Merriweather', value: 'Merriweather, serif', weight: '400,700' }
  ],
  defaultColors: {
    primary: '#460B0D',
    secondary: '#F2F2F2',
    accent: '#881346',
    background: '#FFFFFF',
    text: '#111111',
    cardBg: '#F2F2F2',
    borderColor: '#E2E2E2'
  },
  defaultFont: 'Lora, serif',
  themeStyle: {
    layout: 'elegant-card',
    headerStyle: 'banner-overlay',
    cardStyle: 'clean-modern',
    buttonStyle: 'rounded',
    iconStyle: 'filled',
    spacing: 'comfortable',
    shadows: 'subtle',
    animations: 'smooth',
    backgroundPattern: 'none'
  },
  defaultData: {
    header: {
      name: 'Jolie Doe',
      title: 'Event & Wedding Planner',
      tagline: 'Creating unforgettable moments and bringing your dreams to life',
      profile_image: '',
      banner_image: '',
      banner_bg_image: ''
    },
    contact: {
      email: 'kontakt@alpesh.com',
      phone: '+91 1122334455',
      website: 'https://www.linkedin.com/',
      location: 'New York, NY'
    },
    about: {
      description: 'Professional actor with extensive experience in theater, film, and television. Passionate about bringing characters to life and telling compelling stories that resonate with audiences.',
      experience: '8',
      specialties: 'Theater, Film, Television, Voice Acting, Commercial Acting'
    },
    gallery: {
      media_list: [
        { title: 'Headshot Portfolio', type: 'image', image: '', video_url: '', thumbnail: '' },
        { title: 'Behind the Scenes', type: 'image', image: '', video_url: '', thumbnail: '' },
        { title: 'Performance Reel', type: 'video', image: '', video_url: '', thumbnail: '' },
        { title: 'Stage Performance', type: 'image', image: '', video_url: '', thumbnail: '' }
      ]
    },
    services: {
      service_list: [
        { title: 'Theater Performance', description: 'Professional stage acting for theatrical productions', image: '', url: '' },
        { title: 'Film & TV Acting', description: 'On-camera work for movies, series, and commercials', image: '', url: '' }
      ]
    },
    social: {
      social_links: [
        { platform: 'facebook', url: 'https://facebook.com', username: 'actorname' },
        { platform: 'twitter', url: 'https://x.com', username: '@actorname' },
        { platform: 'instagram', url: 'https://instagram.com', username: 'actorname' },
        { platform: 'youtube', url: 'https://youtube.com', username: 'Actor Channel' },
        { platform: 'linkedin', url: 'https://linkedin.com/in/actorname', username: 'actorname' }
      ]
    },
    business_hours: {
      hours: [
        { day: 'monday', open_time: '08:10', close_time: '20:00', is_closed: false },
        { day: 'tuesday', open_time: '08:10', close_time: '20:00', is_closed: false },
        { day: 'wednesday', open_time: '08:10', close_time: '20:00', is_closed: false },
        { day: 'thursday', open_time: '08:10', close_time: '20:00', is_closed: false },
        { day: 'friday', open_time: '08:10', close_time: '20:00', is_closed: false },
        { day: 'saturday', open_time: '08:10', close_time: '20:00', is_closed: false },
        { day: 'sunday', open_time: '', close_time: '', is_closed: true }
      ]
    },
    appointments: {
      booking_url: '',
      calendar_link: '',
      appointment_title: 'Make an Appointment'
    },
    testimonials: {
      reviews: [
        { client_name: 'Director Smith', review: 'It was a very good experience working with this talented actor. Professional and dedicated to the craft.', rating: '5', client_image: '' },
        { client_name: 'Producer Johnson', review: 'Exceptional performance and great work ethic. Highly recommend for any production.', rating: '5', client_image: '' },
        { client_name: 'Casting Director', review: 'Versatile actor with great range. Always delivers outstanding performances.', rating: '5', client_image: '' }
      ]
    },
    google_map: {
      map_embed_url: '',
      directions_url: 'https://maps.google.com/directions'
    },
    app_download: {
      app_store_url: 'https://play.google.com/store/apps/',
      play_store_url: 'https://play.google.com/store/apps/'
    },
    contact_form: {
      form_title: 'Get In Touch',
      form_description: 'Ready to work together? Contact me to discuss your project and let\'s create something amazing.'
    },
    thank_you: {
      message: 'Thank you for your interest! I appreciate you taking the time to view my profile and look forward to connecting with you soon.'
    },
    seo: {
      meta_title: 'Jolie Doe - Professional Actor | Theater, Film & TV',
      meta_description: 'Professional actor with 8+ years experience in theater, film, and television. Available for casting and performance opportunities.',
      keywords: 'actor, actress, theater, film, television, casting, performance, entertainment',
      og_image: ''
    },
    pixels: {
      google_analytics: '',
      facebook_pixel: '',
      gtm_id: '',
      custom_head: '',
      custom_body: ''
    },
    custom_html: {
      html_content: '<div class="custom-section"><h4>Featured Work</h4><p>Check out my latest performances and projects.</p></div>',
      section_title: 'Featured Content',
      show_title: true
    },
    qr_share: {
      enable_qr: true,
      qr_title: 'Share My Contact',
      qr_description: 'Scan this QR code to save my contact information directly to your phone.',
      qr_size: 'medium'
    },
    language: {
      template_language: 'en',
      enable_language_switcher: false
    },
    action_buttons: {
      contact_button_text: 'Contact',
      appointment_button_text: 'Make An Appointment',
      save_contact_button_text: 'Save',
      share_button_text: 'Share'
    },
    footer: {
      show_footer: true,
      footer_text: 'Ready to bring your vision to life? Let\'s collaborate and create something extraordinary together.',
      footer_links: [
        { title: 'View Portfolio', url: '#gallery' },
        { title: 'Book Meeting', url: '#appointments' },
        { title: 'Contact Me', url: '#contact' }
      ]
    },
    copyright: {
      text: 'Copyright vCardGo-SaaS 2025'
    }
  }
};