function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
import * as React from 'react';
import { cloneElement, isValidElement } from 'react';
import { adaptEventHandlers } from '../util/types';
import { filterProps } from '../util/ReactUtils';
import { Dot } from '../shape/Dot';
import { Layer } from '../container/Layer';
import { useTooltipAxis } from '../context/useTooltipAxis';
import { findEntryInArray, isNullish } from '../util/DataUtils';
import { useAppSelector } from '../state/hooks';
import { selectActiveLabel, selectActiveTooltipIndex } from '../state/selectors/tooltipSelectors';
var renderActivePoint = _ref => {
  var {
    point,
    childIndex,
    mainColor,
    activeDot,
    dataKey
  } = _ref;
  if (activeDot === false || point.x == null || point.y == null) {
    return null;
  }
  var dotProps = _objectSpread(_objectSpread({
    index: childIndex,
    dataKey,
    cx: point.x,
    cy: point.y,
    r: 4,
    fill: mainColor !== null && mainColor !== void 0 ? mainColor : 'none',
    strokeWidth: 2,
    stroke: '#fff',
    payload: point.payload,
    value: point.value
  }, filterProps(activeDot, false)), adaptEventHandlers(activeDot));
  var dot;
  if (/*#__PURE__*/isValidElement(activeDot)) {
    // @ts-expect-error element cloning does not have types
    dot = /*#__PURE__*/cloneElement(activeDot, dotProps);
  } else if (typeof activeDot === 'function') {
    dot = activeDot(dotProps);
  } else {
    dot = /*#__PURE__*/React.createElement(Dot, dotProps);
  }
  return /*#__PURE__*/React.createElement(Layer, {
    className: "recharts-active-dot"
  }, dot);
};
export function ActivePoints(_ref2) {
  var {
    points,
    mainColor,
    activeDot,
    itemDataKey
  } = _ref2;
  var tooltipAxis = useTooltipAxis();
  var activeTooltipIndex = useAppSelector(selectActiveTooltipIndex);
  var activeLabel = useAppSelector(selectActiveLabel);
  if (!activeTooltipIndex) {
    return null;
  }
  var activePoint;
  var tooltipAxisDataKey = tooltipAxis.dataKey;
  if (tooltipAxisDataKey && !tooltipAxis.allowDuplicatedCategory) {
    var specifiedKey = typeof tooltipAxisDataKey === 'function' ? point => tooltipAxisDataKey(point.payload) : "payload.".concat(tooltipAxisDataKey);
    activePoint = findEntryInArray(points, specifiedKey, activeLabel);
  } else {
    activePoint = points === null || points === void 0 ? void 0 : points[Number(activeTooltipIndex)];
  }
  if (isNullish(activePoint)) {
    return null;
  }
  return renderActivePoint({
    point: activePoint,
    childIndex: Number(activeTooltipIndex),
    mainColor,
    dataKey: itemDataKey,
    activeDot
  });
}