<?php

namespace Database\Seeders;

use App\Models\LandingPageCustomPage;
use Illuminate\Database\Seeder;

class LandingPageCustomPageSeeder extends Seeder
{
    public function run(): void
    {
        $pages = [
            [
                'title' => 'About Us',
                'slug' => 'about-us',
                'content' => '<div class="py-12 sm:py-16 lg:py-20 bg-gray-50"><div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8"><div class="text-center mb-8 sm:mb-12 lg:mb-16"><h1 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">About vCard</h1><p class="text-lg text-gray-600 max-w-3xl mx-auto leading-relaxed font-medium">Revolutionizing digital networking with <span style="color: var(--primary-color, #3b82f6);" class="font-semibold">innovative business card solutions</span></p></div><div class="grid lg:grid-cols-2 gap-8 sm:gap-12 lg:gap-16 items-center mb-8 sm:mb-12 lg:mb-16"><div><h2 class="text-2xl font-bold text-gray-900 mb-6">Empowering Professional Connections Since 2020</h2><div class="text-gray-600 mb-8 leading-relaxed"><p class="mb-6">vCard SaaS is a leading digital business card platform that helps businesses create professional online presence. Our mission is to revolutionize how businesses connect and share information in the digital age.</p><p class="mb-6">Founded with the vision of making networking seamless and efficient, we provide cutting-edge solutions for modern businesses. We believe that every connection matters and every interaction should leave a lasting impression.</p></div><div class="flex items-center gap-8"><div class="text-center"><div class="text-2xl font-bold text-gray-900">4+ Years</div><div class="text-sm text-gray-600">Experience</div></div><div class="text-center"><div class="text-2xl font-bold text-gray-900">10K+</div><div class="text-sm text-gray-600">Happy Users</div></div><div class="text-center"><div class="text-2xl font-bold text-gray-900">50+</div><div class="text-sm text-gray-600">Countries</div></div></div></div><div class="bg-white rounded-xl p-8 border border-gray-200 h-96 flex items-center justify-center"><div class="text-center"><div class="w-24 h-24 bg-gray-100 rounded-full mx-auto mb-6 flex items-center justify-center"><span class="text-3xl">🚀</span></div><h3 class="text-xl font-semibold text-gray-900 mb-2">Innovation Driven</h3><p class="text-gray-600">Building the future of networking</p></div></div></div><div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6 sm:gap-8"><div class="text-center bg-white p-6 rounded-xl border border-gray-200"><div class="w-12 h-12 rounded-lg flex items-center justify-center mx-auto mb-4" style="background-color: var(--primary-color, #3b82f6); opacity: 0.1;"><svg class="w-6 h-6" style="color: var(--primary-color, #3b82f6);" fill="currentColor" viewBox="0 0 20 20"><path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/></svg></div><h3 class="text-lg font-semibold text-gray-900 mb-3">Our Mission</h3><p class="text-gray-600 text-sm leading-relaxed">To revolutionize professional networking by making digital business cards accessible, efficient, and environmentally friendly.</p></div><div class="text-center bg-white p-6 rounded-xl border border-gray-200"><div class="w-12 h-12 rounded-lg flex items-center justify-center mx-auto mb-4" style="background-color: var(--secondary-color, #8b5cf6); opacity: 0.1;"><svg class="w-6 h-6" style="color: var(--secondary-color, #8b5cf6);" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M3.172 5.172a4 4 0 015.656 0L10 6.343l1.172-1.171a4 4 0 115.656 5.656L10 17.657l-6.828-6.829a4 4 0 010-5.656z" clip-rule="evenodd"/></svg></div><h3 class="text-lg font-semibold text-gray-900 mb-3">Our Values</h3><p class="text-gray-600 text-sm leading-relaxed">We believe in innovation, sustainability, and building genuine connections that drive business success.</p></div><div class="text-center bg-white p-6 rounded-xl border border-gray-200"><div class="w-12 h-12 rounded-lg flex items-center justify-center mx-auto mb-4" style="background-color: var(--accent-color, #10b77f); opacity: 0.1;"><svg class="w-6 h-6" style="color: var(--accent-color, #10b77f);" fill="currentColor" viewBox="0 0 20 20"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/></svg></div><h3 class="text-lg font-semibold text-gray-900 mb-3">Our Commitment</h3><p class="text-gray-600 text-sm leading-relaxed">Delivering exceptional user experience with cutting-edge technology and unparalleled customer support.</p></div><div class="text-center bg-white p-6 rounded-xl border border-gray-200"><div class="w-12 h-12 rounded-lg flex items-center justify-center mx-auto mb-4" style="background-color: var(--primary-color, #3b82f6); opacity: 0.1;"><svg class="w-6 h-6" style="color: var(--primary-color, #3b82f6);" fill="currentColor" viewBox="0 0 20 20"><path d="M9.663 17h4.673M12 3v1m6.364 1.636l-.707.707M21 12h-1M4 12H3m3.343-5.657l-.707-.707m2.828 9.9a5 5 0 117.072 0l-.548.547A3.374 3.374 0 0014 18.469V19a2 2 0 11-4 0v-.531c0-.895-.356-1.754-.988-2.386l-.548-.547z"/></svg></div><h3 class="text-lg font-semibold text-gray-900 mb-3">Our Vision</h3><p class="text-gray-600 text-sm leading-relaxed">A world where every professional interaction is seamless, memorable, and leads to meaningful business relationships.</p></div></div></div></div>',
                'meta_title' => 'About Us - vCard SaaS Digital Business Cards',
                'meta_description' => 'Learn about vCard SaaS, the leading platform for digital business cards and professional networking solutions.',
                'is_active' => true,
                'sort_order' => 1
            ],
            [
                'title' => 'Privacy Policy',
                'slug' => 'privacy-policy',
                'content' => '<div class="py-12 sm:py-16 lg:py-20 bg-gray-50"><div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8"><div class="text-center mb-8 sm:mb-12 lg:mb-16"><h1 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">Privacy Policy</h1><p class="text-lg text-gray-600 max-w-3xl mx-auto leading-relaxed font-medium">Your privacy is important to us. This policy explains how we collect, use, and protect your information.</p></div><div class="bg-white rounded-xl p-8 border border-gray-200 space-y-8"><div class="border-l-4 border-blue-500 pl-6"><h2 class="text-2xl font-bold text-gray-900 mb-4">Information We Collect</h2><p class="text-gray-600 mb-4 leading-relaxed">We collect information you provide directly to us, including:</p><ul class="space-y-2 text-gray-600"><li class="flex items-start"><span class="w-2 h-2 bg-blue-500 rounded-full mt-2 mr-3 flex-shrink-0"></span>Account registration information</li><li class="flex items-start"><span class="w-2 h-2 bg-blue-500 rounded-full mt-2 mr-3 flex-shrink-0"></span>Profile and business card details</li><li class="flex items-start"><span class="w-2 h-2 bg-blue-500 rounded-full mt-2 mr-3 flex-shrink-0"></span>Communication preferences</li><li class="flex items-start"><span class="w-2 h-2 bg-blue-500 rounded-full mt-2 mr-3 flex-shrink-0"></span>Usage analytics and performance data</li></ul></div><div class="border-l-4 border-green-500 pl-6"><h2 class="text-2xl font-bold text-gray-900 mb-4">How We Use Your Information</h2><p class="text-gray-600 mb-4 leading-relaxed">We use the information we collect to:</p><ul class="space-y-2 text-gray-600"><li class="flex items-start"><span class="w-2 h-2 bg-green-500 rounded-full mt-2 mr-3 flex-shrink-0"></span>Provide and maintain our services</li><li class="flex items-start"><span class="w-2 h-2 bg-green-500 rounded-full mt-2 mr-3 flex-shrink-0"></span>Process transactions and send notifications</li><li class="flex items-start"><span class="w-2 h-2 bg-green-500 rounded-full mt-2 mr-3 flex-shrink-0"></span>Improve our platform and user experience</li><li class="flex items-start"><span class="w-2 h-2 bg-green-500 rounded-full mt-2 mr-3 flex-shrink-0"></span>Communicate with you about updates and features</li></ul></div><div class="border-l-4 border-purple-500 pl-6"><h2 class="text-2xl font-bold text-gray-900 mb-4">Information Sharing</h2><p class="text-gray-600 leading-relaxed">We do not sell, trade, or otherwise transfer your personal information to third parties without your explicit consent, except as described in this policy.</p></div><div class="border-l-4 border-red-500 pl-6"><h2 class="text-2xl font-bold text-gray-900 mb-4">Data Security</h2><p class="text-gray-600 leading-relaxed">We implement appropriate security measures to protect your personal information against unauthorized access, alteration, disclosure, or destruction.</p></div></div></div></div>',
                'meta_title' => 'Privacy Policy - vCard SaaS',
                'meta_description' => 'Read our privacy policy to understand how we collect, use, and protect your personal information.',
                'is_active' => true,
                'sort_order' => 2
            ],
            [
                'title' => 'Terms of Service',
                'slug' => 'terms-of-service',
                'content' => '<div class="py-12 sm:py-16 lg:py-20 bg-gray-50"><div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8"><div class="text-center mb-8 sm:mb-12 lg:mb-16"><h1 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">Terms of Service</h1><p class="text-lg text-gray-600 max-w-3xl mx-auto leading-relaxed font-medium">Please read these terms carefully before using our services.</p></div><div class="bg-white rounded-xl p-8 border border-gray-200 space-y-8"><div class="border-l-4 border-blue-500 pl-6"><h2 class="text-2xl font-bold text-gray-900 mb-4">Acceptance of Terms</h2><p class="text-gray-600 leading-relaxed">By accessing and using vCard, you accept and agree to be bound by the terms and provisions of this agreement. If you do not agree to these terms, please do not use our service.</p></div><div class="border-l-4 border-green-500 pl-6"><h2 class="text-2xl font-bold text-gray-900 mb-4">Service Description</h2><p class="text-gray-600 mb-4 leading-relaxed">vCard SaaS provides digital business card creation and sharing services, including:</p><ul class="space-y-2 text-gray-600"><li class="flex items-start"><span class="w-2 h-2 bg-green-500 rounded-full mt-2 mr-3 flex-shrink-0"></span>Custom business card design tools</li><li class="flex items-start"><span class="w-2 h-2 bg-green-500 rounded-full mt-2 mr-3 flex-shrink-0"></span>QR code generation and management</li><li class="flex items-start"><span class="w-2 h-2 bg-green-500 rounded-full mt-2 mr-3 flex-shrink-0"></span>Analytics and contact management</li><li class="flex items-start"><span class="w-2 h-2 bg-green-500 rounded-full mt-2 mr-3 flex-shrink-0"></span>Integration with third-party services</li></ul></div><div class="border-l-4 border-purple-500 pl-6"><h2 class="text-2xl font-bold text-gray-900 mb-4">User Responsibilities</h2><p class="text-gray-600 mb-4 leading-relaxed">You are responsible for:</p><ul class="space-y-2 text-gray-600"><li class="flex items-start"><span class="w-2 h-2 bg-purple-500 rounded-full mt-2 mr-3 flex-shrink-0"></span>Maintaining the confidentiality of your account</li><li class="flex items-start"><span class="w-2 h-2 bg-purple-500 rounded-full mt-2 mr-3 flex-shrink-0"></span>All activities that occur under your account</li><li class="flex items-start"><span class="w-2 h-2 bg-purple-500 rounded-full mt-2 mr-3 flex-shrink-0"></span>Ensuring your content complies with applicable laws</li><li class="flex items-start"><span class="w-2 h-2 bg-purple-500 rounded-full mt-2 mr-3 flex-shrink-0"></span>Respecting intellectual property rights</li></ul></div><div class="border-l-4 border-red-500 pl-6"><h2 class="text-2xl font-bold text-gray-900 mb-4">Limitation of Liability</h2><p class="text-gray-600 leading-relaxed">vCard SaaS shall not be liable for any indirect, incidental, special, consequential, or punitive damages resulting from your use of the service.</p></div></div></div></div>',
                'meta_title' => 'Terms of Service - vCard SaaS',
                'meta_description' => 'Read our terms of service to understand the rules and regulations for using vCard SaaS platform.',
                'is_active' => true,
                'sort_order' => 3
            ],
            [
                'title' => 'Contact Us',
                'slug' => 'contact-us',
                'content' => '<div class="py-12 sm:py-16 lg:py-20 bg-gray-50"><div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8"><div class="text-center mb-8 sm:mb-12 lg:mb-16"><h1 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">Get in Touch</h1><p class="text-lg text-gray-600 max-w-3xl mx-auto leading-relaxed font-medium">We\'re here to help! <span class="text-blue-600 font-semibold">Get in touch</span> with our team</p></div><div class="grid lg:grid-cols-2 gap-8 sm:gap-12 lg:gap-16"><div><div class="bg-white border border-gray-200 rounded-xl p-8"><h2 class="text-2xl font-bold text-gray-900 mb-6">Send us a Message</h2><form class="space-y-6"><div class="grid grid-cols-1 sm:grid-cols-2 gap-4 sm:gap-6"><div><label class="block text-sm font-medium text-gray-700 mb-2">Full Name <span class="text-red-500">*</span></label><input type="text" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500" placeholder="Your full name" required></div><div><label class="block text-sm font-medium text-gray-700 mb-2">Email Address <span class="text-red-500">*</span></label><input type="email" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500" placeholder="your@email.com" required></div></div><div><label class="block text-sm font-medium text-gray-700 mb-2">Subject <span class="text-red-500">*</span></label><input type="text" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500" placeholder="What\'s this about?" required></div><div><label class="block text-sm font-medium text-gray-700 mb-2">Message <span class="text-red-500">*</span></label><textarea rows="6" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 resize-none" placeholder="Tell us more about your inquiry..." required></textarea></div><button type="submit" class="w-full bg-blue-600 text-white px-8 py-4 rounded-lg transition-colors font-semibold hover:bg-blue-700 flex items-center justify-center gap-2"><svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20"><path d="M10.894 2.553a1 1 0 00-1.788 0l-7 14a1 1 0 001.169 1.409l5-1.429A1 1 0 009 15.571V11a1 1 0 112 0v4.571a1 1 0 00.725.962l5 1.428a1 1 0 001.17-1.408l-7-14z"/></svg>Send Message</button></form></div></div><div><div class="space-y-8"><div><h2 class="text-2xl font-bold text-gray-900 mb-6">Contact Information</h2><p class="text-gray-600 mb-8">We\'re here to help and answer any question you might have. We look forward to hearing from you.</p></div><div class="space-y-6"><div class="flex items-start gap-4"><div class="w-12 h-12 bg-blue-50 rounded-lg flex items-center justify-center flex-shrink-0"><svg class="w-6 h-6 text-blue-600" fill="currentColor" viewBox="0 0 20 20"><path d="M2.003 5.884L10 9.882l7.997-3.998A2 2 0 0016 4H4a2 2 0 00-1.997 1.884z"/><path d="M18 8.118l-8 4-8-4V14a2 2 0 002 2h12a2 2 0 002-2V8.118z"/></svg></div><div><h3 class="text-lg font-semibold text-gray-900 mb-1">Email Us</h3><p class="text-gray-900 font-medium mb-1">support@vCard.com</p><p class="text-gray-600 text-sm">Send us an email anytime!</p></div></div><div class="flex items-start gap-4"><div class="w-12 h-12 bg-purple-50 rounded-lg flex items-center justify-center flex-shrink-0"><svg class="w-6 h-6 text-purple-600" fill="currentColor" viewBox="0 0 20 20"><path d="M2 3a1 1 0 011-1h2.153a1 1 0 01.986.836l.74 4.435a1 1 0 01-.54 1.06l-1.548.773a11.037 11.037 0 006.105 6.105l.774-1.548a1 1 0 011.059-.54l4.435.74a1 1 0 01.836.986V17a1 1 0 01-1 1h-2C7.82 18 2 12.18 2 5V3z"/></svg></div><div><h3 class="text-lg font-semibold text-gray-900 mb-1">Call Us</h3><p class="text-gray-900 font-medium mb-1">+1 (555) 123-4567</p><p class="text-gray-600 text-sm">Mon-Fri from 8am to 5pm</p></div></div><div class="flex items-start gap-4"><div class="w-12 h-12 bg-green-50 rounded-lg flex items-center justify-center flex-shrink-0"><svg class="w-6 h-6 text-green-600" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M5.05 4.05a7 7 0 119.9 9.9L10 18.9l-4.95-4.95a7 7 0 010-9.9zM10 11a2 2 0 100-4 2 2 0 000 4z" clip-rule="evenodd"/></svg></div><div><h3 class="text-lg font-semibold text-gray-900 mb-1">Visit Us</h3><p class="text-gray-900 font-medium mb-1">123 Business Ave, Suite 100</p><p class="text-gray-600 text-sm">San Francisco, CA 94105</p></div></div></div><div class="bg-white rounded-xl p-6 border border-gray-200"><h3 class="text-lg font-semibold text-gray-900 mb-4">Business Hours</h3><div class="space-y-3"><div class="flex justify-between items-center py-2 border-b border-gray-100"><span class="font-medium text-gray-700">Monday - Friday</span><span class="text-blue-600 font-semibold">9:00 AM - 6:00 PM EST</span></div><div class="flex justify-between items-center py-2 border-b border-gray-100"><span class="font-medium text-gray-700">Saturday</span><span class="text-purple-600 font-semibold">10:00 AM - 4:00 PM EST</span></div><div class="flex justify-between items-center py-2"><span class="font-medium text-gray-700">Sunday</span><span class="text-green-600 font-semibold">Closed</span></div></div></div></div></div></div></div>',
                'meta_title' => 'Contact Us - vCard SaaS Support',
                'meta_description' => 'Contact vCard SaaS support team for assistance with your digital business card needs.',
                'is_active' => true,
                'sort_order' => 4
            ],
            [
                'title' => 'FAQ',
                'slug' => 'faq',
                'content' => '<div class="py-12 sm:py-16 lg:py-20 bg-gray-50"><div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8"><div class="text-center mb-8 sm:mb-12 lg:mb-16"><h1 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">Frequently Asked Questions</h1><p class="text-lg text-gray-600 max-w-3xl mx-auto leading-relaxed font-medium">Find quick answers to the most <span class="text-blue-600 font-semibold">common questions</span></p></div><div class="space-y-8"><div class="bg-white rounded-xl p-8 border border-gray-200"><div class="flex items-center mb-6"><div class="w-12 h-12 bg-blue-50 rounded-lg flex items-center justify-center mr-4"><svg class="w-6 h-6 text-blue-600" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-8-3a1 1 0 00-.867.5 1 1 0 11-1.731-1A3 3 0 0113 8a3.001 3.001 0 01-2 2.83V11a1 1 0 11-2 0v-1a1 1 0 011-1 1 1 0 100-2zm0 8a1 1 0 100-2 1 1 0 000 2z" clip-rule="evenodd"/></svg></div><h2 class="text-2xl font-bold text-gray-900">Getting Started</h2></div><div class="space-y-6"><div class="border-l-4 border-blue-500 pl-6"><h3 class="text-lg font-semibold text-gray-900 mb-3">What is vCard?</h3><p class="text-gray-600 leading-relaxed">vCard SaaS is a comprehensive digital business card platform that allows you to create, customize, and share professional business cards online. Say goodbye to paper cards and hello to smart networking.</p></div><div class="border-l-4 border-blue-500 pl-6"><h3 class="text-lg font-semibold text-gray-900 mb-3">How do I create my first business card?</h3><p class="text-gray-600 mb-4 leading-relaxed">Creating your business card is simple:</p><div class="bg-gray-50 p-4 rounded-lg"><ol class="space-y-2 text-gray-700"><li class="flex items-center"><span class="w-6 h-6 bg-blue-600 text-white rounded-full flex items-center justify-center text-sm font-bold mr-3">1</span>Sign up for a free account</li><li class="flex items-center"><span class="w-6 h-6 bg-blue-600 text-white rounded-full flex items-center justify-center text-sm font-bold mr-3">2</span>Choose from our professional templates</li><li class="flex items-center"><span class="w-6 h-6 bg-blue-600 text-white rounded-full flex items-center justify-center text-sm font-bold mr-3">3</span>Add your contact information and branding</li><li class="flex items-center"><span class="w-6 h-6 bg-blue-600 text-white rounded-full flex items-center justify-center text-sm font-bold mr-3">4</span>Customize colors, fonts, and layout</li><li class="flex items-center"><span class="w-6 h-6 bg-blue-600 text-white rounded-full flex items-center justify-center text-sm font-bold mr-3">5</span>Share via QR code, link, or NFC</li></ol></div></div></div></div><div class="bg-white rounded-xl p-8 border border-gray-200"><div class="flex items-center mb-6"><div class="w-12 h-12 bg-purple-50 rounded-lg flex items-center justify-center mr-4"><svg class="w-6 h-6 text-purple-600" fill="currentColor" viewBox="0 0 20 20"><path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/></svg></div><h2 class="text-2xl font-bold text-gray-900">Features & Plans</h2></div><div class="grid md:grid-cols-2 gap-6"><div class="border-l-4 border-purple-500 pl-6"><h3 class="text-lg font-semibold text-gray-900 mb-3">Can I use my own domain?</h3><p class="text-gray-600 leading-relaxed">Yes! Premium and Enterprise plans include custom domain support, allowing you to use your own branded URL for your digital business cards.</p></div><div class="border-l-4 border-purple-500 pl-6"><h3 class="text-lg font-semibold text-gray-900 mb-3">Is there a mobile app?</h3><p class="text-gray-600 leading-relaxed">vCard SaaS is fully responsive and works perfectly on all devices. We also offer native mobile apps for iOS and Android with additional features like NFC sharing.</p></div></div></div><div class="bg-white rounded-xl p-8 border border-gray-200"><div class="flex items-center mb-6"><div class="w-12 h-12 bg-green-50 rounded-lg flex items-center justify-center mr-4"><svg class="w-6 h-6 text-green-600" fill="currentColor" viewBox="0 0 20 20"><path d="M2 11a1 1 0 011-1h2a1 1 0 011 1v5a1 1 0 01-1 1H3a1 1 0 01-1-1v-5zM8 7a1 1 0 011-1h2a1 1 0 011 1v9a1 1 0 01-1 1H9a1 1 0 01-1-1V7zM14 4a1 1 0 011-1h2a1 1 0 011 1v12a1 1 0 01-1 1h-2a1 1 0 01-1-1V4z"/></svg></div><h2 class="text-2xl font-bold text-gray-900">Analytics & Support</h2></div><div class="border-l-4 border-green-500 pl-6"><h3 class="text-lg font-semibold text-gray-900 mb-3">How do I track my card performance?</h3><p class="text-gray-600 mb-4 leading-relaxed">Our built-in analytics dashboard shows you detailed insights including:</p><div class="grid grid-cols-2 md:grid-cols-4 gap-4 text-center"><div class="bg-blue-50 p-3 rounded-lg"><div class="text-2xl font-bold text-blue-600">👁️</div><div class="text-sm text-gray-600">Views</div></div><div class="bg-green-50 p-3 rounded-lg"><div class="text-2xl font-bold text-green-600">👆</div><div class="text-sm text-gray-600">Clicks</div></div><div class="bg-purple-50 p-3 rounded-lg"><div class="text-2xl font-bold text-purple-600">📱</div><div class="text-sm text-gray-600">Saves</div></div><div class="bg-orange-50 p-3 rounded-lg"><div class="text-2xl font-bold text-orange-600">📊</div><div class="text-sm text-gray-600">Engagement</div></div></div></div></div></div></div></div>',
                'meta_title' => 'FAQ - vCard SaaS Help Center',
                'meta_description' => 'Find answers to frequently asked questions about vCard SaaS digital business cards.',
                'is_active' => true,
                'sort_order' => 5
            ],
            [
                'title' => 'Refund Policy',
                'slug' => 'refund-policy',
                'content' => '<div class="py-12 sm:py-16 lg:py-20 bg-gray-50"><div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8"><div class="text-center mb-8 sm:mb-12 lg:mb-16"><h1 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">Refund Policy</h1><p class="text-lg text-gray-600 max-w-3xl mx-auto leading-relaxed font-medium">We stand behind our service with a satisfaction guarantee. Here\'s everything you need to know about our refund policy.</p></div><div class="bg-white rounded-xl p-8 border border-gray-200 space-y-8"><div class="rounded-xl p-6" style="background-color: var(--primary-color, #3b82f6); border: 1px solid rgba(var(--primary-color-rgb, 59, 130, 246), 0.2);"><div class="flex items-center mb-4"><div class="w-12 h-12 rounded-full flex items-center justify-center mr-4" style="background-color: var(--primary-color, #3b82f6);"><svg class="w-6 h-6 text-white" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/></svg></div><h2 class="text-2xl font-bold text-gray-900">30-Day Money Back Guarantee</h2></div><p class="text-gray-700 leading-relaxed">We offer a <strong>30-day money back guarantee</strong> for all premium plans. If you\'re not completely satisfied with vCard, we\'ll refund your payment in full.</p></div><div class="border-l-4 pl-6" style="border-color: var(--primary-color, #3b82f6);"><h2 class="text-2xl font-bold text-gray-900 mb-4">Eligible Refunds</h2><p class="text-gray-600 mb-4 leading-relaxed">Refunds are available for:</p><ul class="space-y-2 text-gray-600"><li class="flex items-start"><span class="w-2 h-2 rounded-full mt-2 mr-3 flex-shrink-0" style="background-color: var(--primary-color, #3b82f6);"></span>Monthly and annual subscription plans</li><li class="flex items-start"><span class="w-2 h-2 rounded-full mt-2 mr-3 flex-shrink-0" style="background-color: var(--primary-color, #3b82f6);"></span>One-time premium features</li><li class="flex items-start"><span class="w-2 h-2 rounded-full mt-2 mr-3 flex-shrink-0" style="background-color: var(--primary-color, #3b82f6);"></span>Unused portions of prepaid services</li></ul></div><div class="border-l-4 pl-6" style="border-color: var(--secondary-color, #8b5cf6);"><h2 class="text-2xl font-bold text-gray-900 mb-4">Refund Process</h2><p class="text-gray-600 mb-4 leading-relaxed">To request a refund:</p><ol class="space-y-2 text-gray-600"><li class="flex items-start"><span class="w-6 h-6 text-white rounded-full flex items-center justify-center text-sm font-bold mr-3 mt-0.5 flex-shrink-0" style="background-color: var(--secondary-color, #8b5cf6);">1</span>Contact our support team within 30 days of purchase</li><li class="flex items-start"><span class="w-6 h-6 text-white rounded-full flex items-center justify-center text-sm font-bold mr-3 mt-0.5 flex-shrink-0" style="background-color: var(--secondary-color, #8b5cf6);">2</span>Provide your account details and reason for refund</li><li class="flex items-start"><span class="w-6 h-6 text-white rounded-full flex items-center justify-center text-sm font-bold mr-3 mt-0.5 flex-shrink-0" style="background-color: var(--secondary-color, #8b5cf6);">3</span>We\'ll process your request within 3-5 business days</li><li class="flex items-start"><span class="w-6 h-6 text-white rounded-full flex items-center justify-center text-sm font-bold mr-3 mt-0.5 flex-shrink-0" style="background-color: var(--secondary-color, #8b5cf6);">4</span>Refunds are issued to your original payment method</li></ol></div><div class="border-l-4 pl-6" style="border-color: var(--accent-color, #10b77f);"><h2 class="text-2xl font-bold text-gray-900 mb-4">Non-Refundable Items</h2><p class="text-gray-600 mb-4 leading-relaxed">The following items are non-refundable:</p><ul class="space-y-2 text-gray-600"><li class="flex items-start"><span class="w-2 h-2 rounded-full mt-2 mr-3 flex-shrink-0" style="background-color: var(--accent-color, #10b77f);"></span>Custom development work and integrations</li><li class="flex items-start"><span class="w-2 h-2 rounded-full mt-2 mr-3 flex-shrink-0" style="background-color: var(--accent-color, #10b77f);"></span>Third-party services and add-ons</li><li class="flex items-start"><span class="w-2 h-2 rounded-full mt-2 mr-3 flex-shrink-0" style="background-color: var(--accent-color, #10b77f);"></span>Domain registration fees</li><li class="flex items-start"><span class="w-2 h-2 rounded-full mt-2 mr-3 flex-shrink-0" style="background-color: var(--accent-color, #10b77f);"></span>Services used beyond the 30-day period</li></ul></div><div class="rounded-xl p-6 text-center" style="background-color: var(--primary-color, #3b82f6); border: 1px solid rgba(var(--primary-color-rgb, 59, 130, 246), 0.2);"><h2 class="text-xl font-bold text-gray-900 mb-3">Questions?</h2><p class="text-gray-600 mb-4">If you have any questions about our refund policy, please contact our support team. We\'re here to help!</p><a href="/contact-us" class="inline-block px-6 py-2.5 rounded-lg text-sm font-semibold transition-colors border">Contact Support</a></div></div></div></div>',
                'meta_title' => 'Refund Policy - vCard SaaS',
                'meta_description' => 'Learn about our refund policy and money-back guarantee for vCard SaaS services.',
                'is_active' => true,
                'sort_order' => 6
            ]
        ];

        foreach ($pages as $pageData) {
            LandingPageCustomPage::firstOrCreate(
                ['slug' => $pageData['slug']],
                $pageData
            );
        }

        $this->command->info('Landing page custom pages seeded successfully!');
    }
}