<?php

namespace Database\Seeders;

use App\Models\BusinessDirectoryCustomPage;
use Illuminate\Database\Seeder;

class BusinessDirectoryCustomPageSeeder extends Seeder
{
    public function run(): void
    {
        $pages = [
            [
                'title' => 'About Us',
                'slug' => 'about-us',
                'content' => '<div class="py-12 sm:py-16 lg:py-20 bg-gray-50"><div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8"><div class="text-center mb-8 sm:mb-12 lg:mb-16"><h1 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">About Our Directory</h1><p class="text-lg text-gray-600 max-w-3xl mx-auto leading-relaxed font-medium">Connecting businesses and customers with <span style="color: var(--primary-color, #3b82f6);" class="font-semibold">trusted professional services</span></p></div><div class="grid lg:grid-cols-2 gap-8 sm:gap-12 lg:gap-16 items-center mb-8 sm:mb-12 lg:mb-16"><div><h2 class="text-2xl font-bold text-gray-900 mb-6">Your Trusted Business Directory Since 2020</h2><div class="text-gray-600 mb-8 leading-relaxed"><p class="mb-6">Our comprehensive business directory connects you with trusted professionals and services in your area. We carefully vet each business to ensure quality and reliability for our users.</p><p class="mb-6">Founded with the mission to bridge the gap between businesses and customers, we provide a platform where quality service providers can showcase their expertise and customers can easily find exactly what they need.</p></div><div class="flex items-center gap-8"><div class="text-center"><div class="text-2xl font-bold text-gray-900">4+ Years</div><div class="text-sm text-gray-600">Experience</div></div><div class="text-center"><div class="text-2xl font-bold text-gray-900">5K+</div><div class="text-sm text-gray-600">Businesses</div></div><div class="text-center"><div class="text-2xl font-bold text-gray-900">25+</div><div class="text-sm text-gray-600">Categories</div></div></div></div><div class="bg-white rounded-xl p-8 border border-gray-200 h-96 flex items-center justify-center"><div class="text-center"><div class="w-24 h-24 bg-gray-100 rounded-full mx-auto mb-6 flex items-center justify-center"><span class="text-3xl">🚀</span></div><h3 class="text-xl font-semibold text-gray-900 mb-2">Innovation Driven</h3><p class="text-gray-600">Building the future of business networking</p></div></div></div><div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6 sm:gap-8"><div class="text-center bg-white p-6 rounded-xl border border-gray-200"><div class="w-12 h-12 rounded-lg flex items-center justify-center mx-auto mb-4" style="background-color: var(--primary-color, #3b82f6); opacity: 0.1;"><svg class="w-6 h-6" style="color: var(--primary-color, #3b82f6);" fill="currentColor" viewBox="0 0 20 20"><path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/></svg></div><h3 class="text-lg font-semibold text-gray-900 mb-3">Our Mission</h3><p class="text-gray-600 text-sm leading-relaxed">To provide a platform where businesses can showcase their services and customers can easily find trusted professionals.</p></div><div class="text-center bg-white p-6 rounded-xl border border-gray-200"><div class="w-12 h-12 rounded-lg flex items-center justify-center mx-auto mb-4" style="background-color: var(--secondary-color, #8b5cf6); opacity: 0.1;"><svg class="w-6 h-6" style="color: var(--secondary-color, #8b5cf6);" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M3.172 5.172a4 4 0 015.656 0L10 6.343l1.172-1.171a4 4 0 115.656 5.656L10 17.657l-6.828-6.829a4 4 0 010-5.656z" clip-rule="evenodd"/></svg></div><h3 class="text-lg font-semibold text-gray-900 mb-3">Our Values</h3><p class="text-gray-600 text-sm leading-relaxed">We believe in quality, trust, and building connections that drive business success and customer satisfaction.</p></div><div class="text-center bg-white p-6 rounded-xl border border-gray-200"><div class="w-12 h-12 rounded-lg flex items-center justify-center mx-auto mb-4" style="background-color: var(--accent-color, #10b77f); opacity: 0.1;"><svg class="w-6 h-6" style="color: var(--accent-color, #10b77f);" fill="currentColor" viewBox="0 0 20 20"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/></svg></div><h3 class="text-lg font-semibold text-gray-900 mb-3">Our Commitment</h3><p class="text-gray-600 text-sm leading-relaxed">Delivering exceptional user experience with verified businesses and comprehensive service information.</p></div><div class="text-center bg-white p-6 rounded-xl border border-gray-200"><div class="w-12 h-12 rounded-lg flex items-center justify-center mx-auto mb-4" style="background-color: var(--primary-color, #3b82f6); opacity: 0.1;"><svg class="w-6 h-6" style="color: var(--primary-color, #3b82f6);" fill="currentColor" viewBox="0 0 20 20"><path d="M9.663 17h4.673M12 3v1m6.364 1.636l-.707.707M21 12h-1M4 12H3m3.343-5.657l-.707-.707m2.828 9.9a5 5 0 117.072 0l-.548.547A3.374 3.374 0 0014 18.469V19a2 2 0 11-4 0v-.531c0-.895-.356-1.754-.988-2.386l-.548-.547z"/></svg></div><h3 class="text-lg font-semibold text-gray-900 mb-3">Our Vision</h3><p class="text-gray-600 text-sm leading-relaxed">A world where finding trusted business services is simple, efficient, and leads to successful partnerships.</p></div></div></div></div>',
                'meta_title' => 'About Us - Business Directory',
                'meta_description' => 'Learn about our business directory platform that connects customers with trusted professionals and quality service providers.',
                'is_active' => true,
                'sort_order' => 1
            ],
            [
                'title' => 'Privacy Policy',
                'slug' => 'privacy-policy',
                'content' => '<div class="py-12 sm:py-16 lg:py-20 bg-gray-50"><div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8"><div class="text-center mb-8 sm:mb-12 lg:mb-16"><h1 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">Privacy Policy</h1><p class="text-lg text-gray-600 max-w-3xl mx-auto leading-relaxed font-medium">Your privacy is important to us. This policy explains how we collect, use, and protect your information.</p></div><div class="bg-white rounded-xl p-8 border border-gray-200 space-y-8"><div class="border-l-4 border-blue-500 pl-6"><h2 class="text-2xl font-bold text-gray-900 mb-4">Information We Collect</h2><p class="text-gray-600 mb-4 leading-relaxed">We collect information you provide directly to us, including:</p><ul class="space-y-2 text-gray-600"><li class="flex items-start"><span class="w-2 h-2 bg-blue-500 rounded-full mt-2 mr-3 flex-shrink-0"></span>Account registration information</li><li class="flex items-start"><span class="w-2 h-2 bg-blue-500 rounded-full mt-2 mr-3 flex-shrink-0"></span>Business listing details and contact information</li><li class="flex items-start"><span class="w-2 h-2 bg-blue-500 rounded-full mt-2 mr-3 flex-shrink-0"></span>Communication preferences and feedback</li><li class="flex items-start"><span class="w-2 h-2 bg-blue-500 rounded-full mt-2 mr-3 flex-shrink-0"></span>Usage analytics and search behavior</li></ul></div><div class="border-l-4 border-green-500 pl-6"><h2 class="text-2xl font-bold text-gray-900 mb-4">How We Use Your Information</h2><p class="text-gray-600 mb-4 leading-relaxed">We use the information we collect to:</p><ul class="space-y-2 text-gray-600"><li class="flex items-start"><span class="w-2 h-2 bg-green-500 rounded-full mt-2 mr-3 flex-shrink-0"></span>Provide and maintain our directory services</li><li class="flex items-start"><span class="w-2 h-2 bg-green-500 rounded-full mt-2 mr-3 flex-shrink-0"></span>Connect customers with relevant businesses</li><li class="flex items-start"><span class="w-2 h-2 bg-green-500 rounded-full mt-2 mr-3 flex-shrink-0"></span>Improve our platform and search functionality</li><li class="flex items-start"><span class="w-2 h-2 bg-green-500 rounded-full mt-2 mr-3 flex-shrink-0"></span>Send important updates and notifications</li></ul></div><div class="border-l-4 border-purple-500 pl-6"><h2 class="text-2xl font-bold text-gray-900 mb-4">Information Sharing</h2><p class="text-gray-600 leading-relaxed">We do not sell, trade, or otherwise transfer your personal information to third parties without your explicit consent, except as described in this policy for directory functionality.</p></div><div class="border-l-4 border-red-500 pl-6"><h2 class="text-2xl font-bold text-gray-900 mb-4">Data Security</h2><p class="text-gray-600 leading-relaxed">We implement appropriate security measures to protect your personal information against unauthorized access, alteration, disclosure, or destruction.</p></div></div></div></div>',
                'meta_title' => 'Privacy Policy - Business Directory',
                'meta_description' => 'Read our privacy policy to understand how we collect, use, and protect your personal information in our business directory.',
                'is_active' => true,
                'sort_order' => 2
            ],
            [
                'title' => 'Terms of Service',
                'slug' => 'terms-of-service',
                'content' => '<div class="py-12 sm:py-16 lg:py-20 bg-gray-50"><div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8"><div class="text-center mb-8 sm:mb-12 lg:mb-16"><h1 class="text-3xl md:text-4xl font-bold text-gray-900 mb-4">Terms of Service</h1><p class="text-lg text-gray-600 max-w-3xl mx-auto leading-relaxed font-medium">Please read these terms carefully before using our business directory services.</p></div><div class="bg-white rounded-xl p-8 border border-gray-200 space-y-8"><div class="border-l-4 border-blue-500 pl-6"><h2 class="text-2xl font-bold text-gray-900 mb-4">Acceptance of Terms</h2><p class="text-gray-600 leading-relaxed">By accessing and using our business directory, you accept and agree to be bound by the terms and provisions of this agreement. If you do not agree to these terms, please do not use our service.</p></div><div class="border-l-4 border-green-500 pl-6"><h2 class="text-2xl font-bold text-gray-900 mb-4">Service Description</h2><p class="text-gray-600 mb-4 leading-relaxed">Our business directory provides:</p><ul class="space-y-2 text-gray-600"><li class="flex items-start"><span class="w-2 h-2 bg-green-500 rounded-full mt-2 mr-3 flex-shrink-0"></span>Business listing and search functionality</li><li class="flex items-start"><span class="w-2 h-2 bg-green-500 rounded-full mt-2 mr-3 flex-shrink-0"></span>Contact information and business details</li><li class="flex items-start"><span class="w-2 h-2 bg-green-500 rounded-full mt-2 mr-3 flex-shrink-0"></span>Customer reviews and ratings</li><li class="flex items-start"><span class="w-2 h-2 bg-green-500 rounded-full mt-2 mr-3 flex-shrink-0"></span>Category-based business discovery</li></ul></div><div class="border-l-4 border-purple-500 pl-6"><h2 class="text-2xl font-bold text-gray-900 mb-4">User Responsibilities</h2><p class="text-gray-600 mb-4 leading-relaxed">You are responsible for:</p><ul class="space-y-2 text-gray-600"><li class="flex items-start"><span class="w-2 h-2 bg-purple-500 rounded-full mt-2 mr-3 flex-shrink-0"></span>Providing accurate business information</li><li class="flex items-start"><span class="w-2 h-2 bg-purple-500 rounded-full mt-2 mr-3 flex-shrink-0"></span>Maintaining the confidentiality of your account</li><li class="flex items-start"><span class="w-2 h-2 bg-purple-500 rounded-full mt-2 mr-3 flex-shrink-0"></span>Using the directory for legitimate business purposes</li><li class="flex items-start"><span class="w-2 h-2 bg-purple-500 rounded-full mt-2 mr-3 flex-shrink-0"></span>Complying with all applicable laws and regulations</li></ul></div><div class="border-l-4 border-red-500 pl-6"><h2 class="text-2xl font-bold text-gray-900 mb-4">Limitation of Liability</h2><p class="text-gray-600 leading-relaxed">Our business directory shall not be liable for any indirect, incidental, special, consequential, or punitive damages resulting from your use of the service.</p></div></div></div></div>',
                'meta_title' => 'Terms of Service - Business Directory',
                'meta_description' => 'Read our terms of service to understand the rules and regulations for using our business directory platform.',
                'is_active' => true,
                'sort_order' => 3
            ]
        ];

        foreach ($pages as $pageData) {
            BusinessDirectoryCustomPage::firstOrCreate(
                ['slug' => $pageData['slug']],
                $pageData
            );
        }

        $this->command->info('Business directory custom pages seeded successfully!');
    }
}