<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVisitsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable(config('visitor.table_name'))) {
            Schema::create(config('visitor.table_name'), function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->foreignId('business_id')->nullable()->constrained()->onDelete('cascade');
                $table->string('method')->nullable();
                $table->mediumText('request')->nullable();
                $table->mediumText('url')->nullable();
                $table->mediumText('referer')->nullable();
                $table->text('languages')->nullable();
                $table->text('useragent')->nullable();
                $table->text('headers')->nullable();
                $table->text('device')->nullable();
                $table->text('platform')->nullable();
                $table->text('browser')->nullable();
                $table->ipAddress('ip')->nullable();
                $table->nullableMorphs('visitable'); // object model
                $table->nullableMorphs('visitor'); // subject model
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists(config('visitor.table_name'));
    }
}
