<?php

namespace App\Providers;

use App\Models\User;
use App\Models\Plan;
use App\Models\Business;
use App\Observers\UserObserver;
use App\Observers\PlanObserver;
use App\Observers\BusinessObserver;
use App\Providers\AssetServiceProvider;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Schema;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        $this->app->singleton(\App\Services\WebhookService::class);
        
        // Register our AssetServiceProvider
        $this->app->register(AssetServiceProvider::class);
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Schema::defaultStringLength(191);
        // Register the UserObserver
        User::observe(UserObserver::class);
        
        // Register the PlanObserver
        Plan::observe(PlanObserver::class);
        
        // Register the BusinessObserver
        Business::observe(BusinessObserver::class);

        // Configure dynamic storage disks
        $this->app->booted(function () {
            try {
                if (!app()->runningInConsole() && auth()->check()) {
                    \App\Services\DynamicStorageService::configureDynamicDisks();
                }
            } catch (\Exception $e) {
                // Silently fail during migrations or when database is not ready
            }
        });
    }
}